USE [Faainex.Erp.Main.Test]
GO

/****** Object:  StoredProcedure [dbo].[AccLossAndProfit1]    Script Date: 11/4/2025 12:19:29 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


ALTER PROCEDURE [dbo].[AccLossAndProfit1]      
    @FromDate nvarchar(50),
    @ToDate nvarchar(50),
    @AccLevel INT,
    @BranchID int,
    @FileYearID int,
    @Ln int,
    @Stock int,
    @StockOpen int,
    @CostCenterR nvarchar(max),
    @ZeroBalance int,
    @CompanyID int   -- ✅ الباراميتر الجديد
AS
BEGIN

    DECLARE 
        @debitL float, @CreditL float,
        @AccName nvarchar(50),
        @Profit Float, @Loss float,
        @debitLP float, @CreditLP float,
        @AccName1 nvarchar(50),
        @Profit1 Float, @Loss1 float,
        @debitLS float, @CreditLS float,
        @debitLPS float, @CreditLPS float,
        @StockCost float, @Stocks float;

    CREATE TABLE #Temp(
        AccID nvarchar(50),
        AccName nvarchar(50),
        Debit1 float,
        Credit1 float,
        MainFinalAccount int,
        LevelAccount int,
        BranchId int,
        [Status] bit
    );

    SET @StockCost=0;
    SET @Stocks=0;

    -- ✅ إنشاء جدول الفروع حسب منطق الشركة
    DECLARE @BranchTable TABLE (BranchID int);

    IF @CompanyID = 0 AND @BranchID = 0
        INSERT INTO @BranchTable SELECT BWID FROM BranchsAndWarehouse;  -- كل الفروع
    ELSE IF @CompanyID = 0 AND @BranchID <> 0
        INSERT INTO @BranchTable SELECT @BranchID;                       -- فرع واحد
    ELSE IF @CompanyID <> 0 AND @BranchID = 0
        INSERT INTO @BranchTable SELECT BWID FROM BranchsAndWarehouse WHERE CompanyId = @CompanyID; -- فروع الشركة
    ELSE
        INSERT INTO @BranchTable SELECT @BranchID;                       -- فرع محدد ضمن شركة

    -- ✅ حساب تكلفة المخزون
    IF @Stock = 0
    BEGIN
        SELECT @StockCost = ISNULL(SUM(ISNULL(PriceAverage,0) * ISNULL(QuantityAv,0)),0)
        FROM ViewItems
        WHERE BranchID IN (SELECT BranchID FROM @BranchTable);
    END

    -- ✅ حساب رصيد المخزون الافتتاحي
    IF @StockOpen = 0
    BEGIN
        SELECT @Stocks = ISNULL(SUM(StartDebit - StartCredit),0)
        FROM ViewChartOfAccount  
        WHERE AccID = (SELECT accountID FROM MainAccCompany WHERE AccountValue=25)
          AND BranchID IN (SELECT BranchID FROM @BranchTable);
    END

    SET @debitL=0; SET @CreditL=0;
    SET @debitLP=0; SET @CreditLP=0;
    SET @debitLS=0; SET @CreditLS=0;
    SET @debitLPS=0; SET @CreditLPS=0;

    -- ✅ معالجة الحالات مع أو بدون مركز تكلفة
    IF @CostCenterR='0'	
    BEGIN
        SELECT @debitL = ISNULL(SUM(Debit-Credit),0)
        FROM ViewTrialBalance
        WHERE MainFinalAccount = 0 AND LevelAccount = 1 
          AND FinancialID = @FileYearID 
          AND (Debit-Credit)>0
          AND DateGr BETWEEN @FromDate AND @ToDate
          AND BranchID IN (SELECT BranchID FROM @BranchTable);

        SELECT @CreditL = ISNULL(SUM(ABS(Debit-Credit)),0)
        FROM ViewTrialBalance
        WHERE MainFinalAccount = 0 AND LevelAccount = 1 
          AND FinancialID = @FileYearID 
          AND (Debit-Credit)<0
          AND DateGr BETWEEN @FromDate AND @ToDate
          AND BranchID IN (SELECT BranchID FROM @BranchTable);

        SELECT @debitLP = ISNULL(SUM(Debit-Credit),0)
        FROM ViewTrialBalance
        WHERE MainFinalAccount = 1 AND LevelAccount = 1 
          AND FinancialID = @FileYearID 
          AND (Debit-Credit)>0
          AND DateGr BETWEEN @FromDate AND @ToDate
          AND BranchID IN (SELECT BranchID FROM @BranchTable);

        SELECT @CreditLP = ISNULL(SUM(ABS(Debit-Credit)),0)
        FROM ViewTrialBalance
        WHERE MainFinalAccount = 1 AND LevelAccount = 1 
          AND FinancialID = @FileYearID 
          AND (Debit-Credit)<0
          AND DateGr BETWEEN @FromDate AND @ToDate
          AND BranchID IN (SELECT BranchID FROM @BranchTable);

        -- ✅ الأرصدة الافتتاحية من الحسابات
        SELECT @debitLS = ISNULL(SUM(StartDebit-StartCredit),0)
        FROM ViewChartOfAccount
        WHERE MainFinalAccount=0 AND LevelAccount=1 AND FinancialID=@FileYearID
          AND (StartDebit-StartCredit)>0
          AND BranchID IN (SELECT BranchID FROM @BranchTable);

        SELECT @CreditLS = ISNULL(SUM(ABS(StartDebit-StartCredit)),0)
        FROM ViewChartOfAccount
        WHERE MainFinalAccount=0 AND LevelAccount=1 AND FinancialID=@FileYearID
          AND (StartDebit-StartCredit)<0
          AND BranchID IN (SELECT BranchID FROM @BranchTable);

        SELECT @debitLPS = ISNULL(SUM(StartDebit-StartCredit),0)
        FROM ViewChartOfAccount
        WHERE MainFinalAccount=1 AND LevelAccount=1 AND FinancialID=@FileYearID
          AND (StartDebit-StartCredit)>0
          AND BranchID IN (SELECT BranchID FROM @BranchTable);

        SELECT @CreditLPS = ISNULL(SUM(ABS(StartDebit-StartCredit)),0)
        FROM ViewChartOfAccount
        WHERE MainFinalAccount=1 AND LevelAccount=1 AND FinancialID=@FileYearID
          AND (StartDebit-StartCredit)<0
          AND BranchID IN (SELECT BranchID FROM @BranchTable);

        SET @debitL=@debitL+@debitLS;
        SET @CreditL=@CreditL+@CreditLS;
        SET @debitLp=@debitLp+@debitLpS;
        SET @CreditLp=@CreditLp+@CreditLpS;
    END
    ELSE
    BEGIN
        SELECT @debitL = ISNULL(SUM(Debit-Credit),0)
        FROM ViewTrialBalance
        WHERE MainFinalAccount = 0 AND LevelAccount = 1 
          AND FinancialID=@FileYearID 
          AND (Debit-Credit)>0 
          AND DateGr BETWEEN @FromDate AND @ToDate
          AND CostCenterID IN (SELECT * FROM dbo.CostCenterData(@CostCenterR))
          AND BranchID IN (SELECT BranchID FROM @BranchTable);

        SELECT @CreditL = ISNULL(SUM(ABS(Debit-Credit)),0)
        FROM ViewTrialBalance
        WHERE MainFinalAccount = 0 AND LevelAccount = 1 
          AND FinancialID=@FileYearID 
          AND (Debit-Credit)<0 
          AND DateGr BETWEEN @FromDate AND @ToDate
          AND CostCenterID IN (SELECT * FROM dbo.CostCenterData(@CostCenterR))
          AND BranchID IN (SELECT BranchID FROM @BranchTable);

        SELECT @debitLP = ISNULL(SUM(Debit-Credit),0)
        FROM ViewTrialBalance
        WHERE MainFinalAccount = 1 AND LevelAccount = 1 
          AND FinancialID=@FileYearID 
          AND (Debit-Credit)>0 
          AND DateGr BETWEEN @FromDate AND @ToDate
          AND CostCenterID IN (SELECT * FROM dbo.CostCenterData(@CostCenterR))
          AND BranchID IN (SELECT BranchID FROM @BranchTable);

        SELECT @CreditLP = ISNULL(SUM(ABS(Debit-Credit)),0)
        FROM ViewTrialBalance
        WHERE MainFinalAccount = 1 AND LevelAccount = 1 
          AND FinancialID=@FileYearID 
          AND (Debit-Credit)<0 
          AND DateGr BETWEEN @FromDate AND @ToDate
          AND CostCenterID IN (SELECT * FROM dbo.CostCenterData(@CostCenterR))
          AND BranchID IN (SELECT BranchID FROM @BranchTable);

        -- ✅ الأرصدة الافتتاحية
        SELECT @debitLS = ISNULL(SUM(StartDebit-StartCredit),0)
        FROM ViewChartOfAccount
        WHERE MainFinalAccount=0 AND LevelAccount=1 AND FinancialID=@FileYearID
          AND (StartDebit-StartCredit)>0
          AND BranchID IN (SELECT BranchID FROM @BranchTable);

        SELECT @CreditLS = ISNULL(SUM(ABS(StartDebit-StartCredit)),0)
        FROM ViewChartOfAccount
        WHERE MainFinalAccount=0 AND LevelAccount=1 AND FinancialID=@FileYearID
          AND (StartDebit-StartCredit)<0
          AND BranchID IN (SELECT BranchID FROM @BranchTable);

        SELECT @debitLPS = ISNULL(SUM(StartDebit-StartCredit),0)
        FROM ViewChartOfAccount
        WHERE MainFinalAccount=1 AND LevelAccount=1 AND FinancialID=@FileYearID
          AND (StartDebit-StartCredit)>0
          AND BranchID IN (SELECT BranchID FROM @BranchTable);

        SELECT @CreditLPS = ISNULL(SUM(ABS(StartDebit-StartCredit)),0)
        FROM ViewChartOfAccount
        WHERE MainFinalAccount=1 AND LevelAccount=1 AND FinancialID=@FileYearID
          AND (StartDebit-StartCredit)<0
          AND BranchID IN (SELECT BranchID FROM @BranchTable);

        SET @debitL=@debitL+@debitLS;
        SET @CreditL=@CreditL+@CreditLS;
        SET @debitLp=@debitLp+@debitLpS;
        SET @CreditLp=@CreditLp+@CreditLpS;
    END

    -- ✅ حساب الأرباح والخسائر النهائية
    SET @AccName = CASE 
        WHEN @CreditL + @StockCost >= @debitL THEN CASE WHEN @Ln=0 THEN N'## إجـمـالـي ربــح الـمـتـاجرة##' ELSE N'## Total Trading Profit ##' END
        ELSE CASE WHEN @Ln=0 THEN N'## إجـمـالـي خـسـارة الـمـتـاجرة ##' ELSE N'## Total Loss Trading ##' END
    END;

    SET @Profit = CASE WHEN @CreditL + @StockCost >= @debitL THEN (@CreditL + @StockCost) - @debitL ELSE 0 END;
    SET @Loss   = CASE WHEN @CreditL + @StockCost >= @debitL THEN 0 ELSE @debitL - (@CreditL + @StockCost) END;

    INSERT INTO #Temp
    SELECT '0', @AccName, @Loss, @Profit, 0, 1, 1, 1;

    SET @AccName1 = CASE 
        WHEN @Creditlp + @Profit >= @debitlp + @Loss 
            THEN CASE WHEN @Ln=0 THEN N'## صــــافــي الــربـــح ##' ELSE N'## Net Profit ##' END
        ELSE CASE WHEN @Ln=0 THEN N'## صــــافــي الـخـسـارة ##' ELSE N'## Net Loss ##' END 
    END;

    SET @Profit1 = CASE WHEN @Creditlp + @Profit >= @debitlp + @Loss THEN @Creditlp + @Profit - (@debitlp + @Loss) ELSE 0 END;
    SET @Loss1   = CASE WHEN @Creditlp + @Profit >= @debitlp + @Loss THEN 0 ELSE (@debitlp + @Loss) - (@Creditlp + @Profit) END;

    -- ✅ ترحيل الحسابات النهائية للفروع المحددة
    INSERT INTO #Temp
    SELECT 
        AccID, AccName,
        CASE WHEN dbo.GetPreBalDebitT(AccID,@FromDate,@ToDate,@BranchID,@FileYearID,2,@CostCenterR)
               - dbo.GetPreBalCreditT(AccID,@FromDate,@ToDate,@BranchID,@FileYearID,2,@CostCenterR) >= 0 
            THEN dbo.GetPreBalDebitT(AccID,@FromDate,@ToDate,@BranchID,@FileYearID,2,@CostCenterR)
               - dbo.GetPreBalCreditT(AccID,@FromDate,@ToDate,@BranchID,@FileYearID,2,@CostCenterR)
            ELSE 0 END AS Debit1,
        CASE WHEN dbo.GetPreBalDebitT(AccID,@FromDate,@ToDate,@BranchID,@FileYearID,2,@CostCenterR)
               - dbo.GetPreBalCreditT(AccID,@FromDate,@ToDate,@BranchID,@FileYearID,2,@CostCenterR) >= 0 
            THEN 0 
            ELSE ABS(dbo.GetPreBalDebitT(AccID,@FromDate,@ToDate,@BranchID,@FileYearID,2,@CostCenterR)
               - dbo.GetPreBalCreditT(AccID,@FromDate,@ToDate,@BranchID,@FileYearID,2,@CostCenterR)) END AS Credit1,
        MainFinalAccount, LevelAccount, BranchID, [Status]
    FROM ViewChartOfAccount
    WHERE MainFinalAccount=1 AND LevelAccount<=@AccLevel 
      AND BranchID IN (SELECT BranchID FROM @BranchTable)
      AND FinancialID=@FileYearID AND AccID<>'0';

    INSERT INTO #Temp
    SELECT '0', @AccName1, @Profit1, @Loss1, 0, 1, 1, 1;

    INSERT INTO #Temp
    SELECT '0',
           CASE WHEN @Ln=0 THEN N'## الاجمــــالي ##' ELSE N'## Total ##' END,
           (SELECT SUM(Debit1) FROM #Temp WHERE LevelAccount=1),
           (SELECT SUM(Credit1) FROM #Temp WHERE LevelAccount=1),
           0, 0, 1, 1;

    -- ✅ عرض النتائج
    IF @ZeroBalance=0
        SELECT * FROM #Temp;
    ELSE
        SELECT * FROM #Temp WHERE Debit1<>0 OR Credit1<>0;

END
GO

