<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?= form_hidden('_attachment_sale_id', $estimate->id); ?>
<?= form_hidden('_attachment_sale_type', 'estimate'); ?>

<?php
/**
 * دالة التفقيط الاحترافية - تدعم حتى تريليون ريال
 */
if (!function_exists('formatMoneyArabicFull')) {
    function formatMoneyArabicFull($number) {
        $number = number_format($number, 2, '.', '');
        $parts = explode('.', $number);
        $riyal = (int)$parts[0];
        $halala = (int)$parts[1];

        // مصفوفة الأرقام الأساسية
        $ones = [
            '', 'واحد', 'اثنان', 'ثلاثة', 'أربعة', 'خمسة', 'ستة', 'سبعة', 'ثمانية', 'تسعة',
            'عشرة', 'أحد عشر', 'اثنا عشر', 'ثلاثة عشر', 'أربعة عشر', 'خمسة عشر', 
            'ستة عشر', 'سبعة عشر', 'ثمانية عشر', 'تسعة عشر'
        ];

        $tens = [
            '', '', 'عشرون', 'ثلاثون', 'أربعون', 'خمسون', 'ستون', 'سبعون', 'ثمانون', 'تسعون'
        ];

        $hundreds = [
            '', 'مائة', 'مائتان', 'ثلاثمائة', 'أربعمائة', 'خمسمائة', 'ستمائة', 'سبعمائة', 'ثمانمائة', 'تسعمائة'
        ];

        // دالة لتحويل رقم من 0 إلى 999
        $convertHundreds = function($num) use ($ones, $tens, $hundreds) {
            if ($num == 0) return '';
            
            $str = '';
            
            // المئات
            $h = floor($num / 100);
            if ($h > 0) {
                $str = $hundreds[$h];
            }
            
            $remainder = $num % 100;
            
            // من 1 إلى 19
            if ($remainder > 0 && $remainder < 20) {
                if ($str != '') $str .= ' و';
                $str .= $ones[$remainder];
            }
            // من 20 إلى 99
            elseif ($remainder >= 20) {
                $t = floor($remainder / 10);
                $o = $remainder % 10;
                
                if ($str != '') $str .= ' و';
                
                if ($o > 0) {
                    $str .= $ones[$o] . ' و' . $tens[$t];
                } else {
                    $str .= $tens[$t];
                }
            }
            
            return $str;
        };

        // دالة التفقيط الرئيسية
        $convertNumber = function($num) use ($convertHundreds) {
            if ($num == 0) return 'صفر';
            
            $result = '';
            
            // التريليونات
            $trillion = floor($num / 1000000000000);
            if ($trillion > 0) {
                if ($trillion == 1) {
                    $result .= 'تريليون';
                } elseif ($trillion == 2) {
                    $result .= 'تريليونان';
                } elseif ($trillion >= 3 && $trillion <= 10) {
                    $result .= $convertHundreds($trillion) . ' تريليون';
                } else {
                    $result .= $convertHundreds($trillion) . ' تريليون';
                }
                $num %= 1000000000000;
            }
            
            // المليارات
            $billion = floor($num / 1000000000);
            if ($billion > 0) {
                if ($result != '') $result .= ' و';
                if ($billion == 1) {
                    $result .= 'مليار';
                } elseif ($billion == 2) {
                    $result .= 'ملياران';
                } elseif ($billion >= 3 && $billion <= 10) {
                    $result .= $convertHundreds($billion) . ' مليار';
                } else {
                    $result .= $convertHundreds($billion) . ' مليار';
                }
                $num %= 1000000000;
            }
            
            // الملايين
            $million = floor($num / 1000000);
            if ($million > 0) {
                if ($result != '') $result .= ' و';
                if ($million == 1) {
                    $result .= 'مليون';
                } elseif ($million == 2) {
                    $result .= 'مليونان';
                } elseif ($million >= 3 && $million <= 10) {
                    $result .= $convertHundreds($million) . ' ملايين';
                } else {
                    $result .= $convertHundreds($million) . ' مليون';
                }
                $num %= 1000000;
            }
            
            // الآلاف
            $thousand = floor($num / 1000);
            if ($thousand > 0) {
                if ($result != '') $result .= ' و';
                if ($thousand == 1) {
                    $result .= 'ألف';
                } elseif ($thousand == 2) {
                    $result .= 'ألفان';
                } elseif ($thousand >= 3 && $thousand <= 10) {
                    $result .= $convertHundreds($thousand) . ' آلاف';
                } else {
                    $result .= $convertHundreds($thousand) . ' ألف';
                }
                $num %= 1000;
            }
            
            // المئات والعشرات والآحاد
            if ($num > 0) {
                if ($result != '') $result .= ' و';
                $result .= $convertHundreds($num);
            }
            
            return $result;
        };

        // التفقيط النهائي
        $output = 'فقط ' . $convertNumber($riyal) . ' ريال سعودي';
        
        if ($halala > 0) {
            $output .= ' و' . $convertNumber($halala) . ' هللة';
        }
        
        $output .= ' لا غير.';
        
        return $output;
    }
}
?>

<div class="col-md-12 no-padding">
    <div class="panel_s">
        <div class="panel-body">
            <div class="horizontal-scrollable-tabs preview-tabs-top panel-full-width-tabs">
                <div class="scroller arrow-left"><i class="fa fa-angle-left"></i></div>
                <div class="scroller arrow-right"><i class="fa fa-angle-right"></i></div>
                <div class="horizontal-tabs">
                    <ul class="nav nav-tabs nav-tabs-horizontal mbot15" role="tablist">
                        <li role="presentation" class="active">
                            <a href="#tab_estimate" aria-controls="tab_estimate" role="tab" data-toggle="tab">
                                <?= _l('estimate'); ?>
                            </a>
                        </li>
                        <li role="presentation">
                            <a href="#tab_tasks"
                                onclick="init_rel_tasks_table(<?= e($estimate->id); ?>,'estimate'); return false;"
                                aria-controls="tab_tasks" role="tab" data-toggle="tab">
                                <?= _l('tasks'); ?>
                            </a>
                        </li>
                        <li role="presentation">
                            <a href="#tab_activity" aria-controls="tab_activity" role="tab" data-toggle="tab">
                                <?= _l('estimate_view_activity_tooltip'); ?>
                            </a>
                        </li>
                        <li role="presentation">
                            <a href="#tab_reminders"
                                onclick="initDataTable('.table-reminders', admin_url + 'misc/get_reminders/' + <?= $estimate->id; ?> + '/' + 'estimate', undefined, undefined, undefined,[1,'asc']); return false;"
                                aria-controls="tab_reminders" role="tab" data-toggle="tab">
                                <?= _l('estimate_reminders'); ?>
                                <?php
                        $total_reminders = total_rows(
                            db_prefix() . 'reminders',
                            [
                                'isnotified' => 0,
                                'staff'      => get_staff_user_id(),
                                'rel_type'   => 'estimate',
                                'rel_id'     => $estimate->id,
                            ]
                        );
if ($total_reminders > 0) {
    echo '<span class="badge">' . $total_reminders . '</span>';
}
?>
                            </a>
                        </li>
                        <li role="presentation" class="tab-separator">
                            <a href="#tab_notes"
                                onclick="get_sales_notes(<?= e($estimate->id); ?>,'estimates'); return false"
                                aria-controls="tab_notes" role="tab" data-toggle="tab">
                                <?= _l('estimate_notes'); ?>
                                <span class="notes-total">
                                    <?php if ($totalNotes > 0) { ?>
                                    <span
                                        class="badge"><?= e($totalNotes); ?></span>
                                    <?php } ?>
                                </span>
                            </a>
                        </li>
                        <li role="presentation" data-toggle="tooltip"
                            title="<?= _l('emails_tracking'); ?>"
                            class="tab-separator">
                            <a href="#tab_emails_tracking" aria-controls="tab_emails_tracking" role="tab"
                                data-toggle="tab">
                                <?php if (! is_mobile()) { ?>
                                <i class="fa-regular fa-envelope-open" aria-hidden="true"></i>
                                <?php } else { ?>
                                <?= _l('emails_tracking'); ?>
                                <?php } ?>
                            </a>
                        </li>
                        <li role="presentation" data-toggle="tooltip"
                            data-title="<?= _l('view_tracking'); ?>"
                            class="tab-separator">
                            <a href="#tab_views" aria-controls="tab_views" role="tab" data-toggle="tab">
                                <?php if (! is_mobile()) { ?>
                                <i class="fa fa-eye"></i>
                                <?php } else { ?>
                                <?= _l('view_tracking'); ?>
                                <?php } ?>
                            </a>
                        </li>
                        <li role="presentation" data-toggle="tooltip"
                            data-title="<?= _l('toggle_full_view'); ?>"
                            class="tab-separator toggle_view">
                            <a href="#" onclick="small_table_full_view(); return false;">
                                <i class="fa fa-expand"></i>
                            </a>
                        </li>
                        <?php hooks()->do_action('after_admin_estimate_preview_template_tab_menu_last_item', $estimate); ?>
                    </ul>
                </div>
            </div>
            <div class="row mtop20">
                <div class="col-md-3">
                    <?= format_estimate_status($estimate->status, 'mtop5 inline-block'); ?>
                </div>
                <div class="col-md-9">
                    <div class="visible-xs">
                        <div class="mtop10"></div>
                    </div>
                    <div class="pull-right _buttons">
                        <?php if (staff_can('edit', 'estimates')) { ?>
                        <a href="<?= admin_url('estimates/estimate/' . $estimate->id); ?>"
                            class="btn btn-default btn-with-tooltip sm:!tw-px-3" data-toggle="tooltip"
                            title="<?= _l('edit_estimate_tooltip'); ?>"
                            data-placement="bottom"><i class="fa-regular fa-pen-to-square"></i></a>
                        <?php } ?>
                        
                        <!-- زر الـ PDF أيقونة فقط (المتظبط) -->
                        <div class="btn-group">
                            <a href="#" class="btn btn-success dropdown-toggle" data-toggle="dropdown"
                                aria-haspopup="true" aria-expanded="false">
                                <i class="fa-regular fa-file-pdf"></i> <span class="caret"></span>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-right">
                                <li class="hidden-xs">
                                    <a href="<?= admin_url('estimates/pdf/' . $estimate->id . '?output_type=I'); ?>" target="_blank">
                                        <?= _l('view_pdf'); ?>
                                    </a>
                                </li>
                                <li>
                                    <a href="<?= admin_url('estimates/pdf/' . $estimate->id); ?>">
                                        <?= _l('download'); ?>
                                    </a>
                                </li>
                                <li>
                                    <a href="<?= admin_url('estimates/pdf/' . $estimate->id . '?print=true'); ?>" target="_blank">
                                        <?= _l('print'); ?>
                                    </a>
                                </li>
                            </ul>
                        </div>

                        <?php
                     $_tooltip = _l('estimate_sent_to_email_tooltip');
$_tooltip_already_send         = '';
if ($estimate->sent == 1) {
    $_tooltip_already_send = _l('estimate_already_send_to_client_tooltip', time_ago($estimate->datesend));
}
?>
                        <?php if (! empty($estimate->clientid)) { ?>
                        <a href="#" class="estimate-send-to-client btn btn-default btn-with-tooltip sm:!tw-px-3"
                            data-toggle="tooltip"
                            title="<?= e($_tooltip); ?>"
                            data-placement="bottom"><span data-toggle="tooltip"
                                data-title="<?= e($_tooltip_already_send); ?>"><i
                                    class="fa-regular fa-envelope"></i></span></a>
                        <?php } ?>
                        <div class="btn-group">
                            <button type="button" class="btn btn-default pull-left dropdown-toggle"
                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <?= _l('more'); ?>
                                <span class="caret"></span>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-right">
                                <li>
                                    <a href="<?= site_url('estimate/' . $estimate->id . '/' . $estimate->hash) ?>"
                                        target="_blank">
                                        <?= _l('view_estimate_as_client'); ?>
                                    </a>
                                </li>
                                
                                <<?php
                                // التحقق من أن SiteWay مفعَّل
                                $sitesway_enabled = false;
                                $payment_modes = $this->payment_modes_model->get('', [
                                    'active' => 1,
                                ]);

                                foreach ($payment_modes as $mode) {
                                    if ($mode['id'] == 'sitesway' && $mode['active'] == 1) {
                                        $sitesway_enabled = true;
                                        break;
                                    }
                                }

                                if ($sitesway_enabled && !empty($estimate->clientid)) {
                                    $sitesway_url = admin_url('sitesway/pay_estimate/' . $estimate->id);
                                    ?>
                                    <li>
                                        <a href="<?= $sitesway_url; ?>" 
                                        style="color: #2563eb; font-weight: bold;"
                                        onclick="return confirm('سيتم توجيهك لصفحة الدفع. هل تريد المتابعة؟');">
                                            <i class="fa fa-credit-card"></i> الدفع عبر SiteWay
                                        </a>
                                    </li>
                                    <?php
                                }
                                ?>
                                <!-- END: SitesWay Payment Link Modification -->

                                <?php hooks()->do_action('after_estimate_view_as_client_link', $estimate); ?>
                                <?php if (($estimate->status == 2 || $estimate->status == 5) && staff_can('create', 'estimates')) { ?>
                                <li>
                                    <a href="<?= admin_url('estimates/send_expiry_reminder/' . $estimate->id); ?>">
                                        <?= _l('send_expiry_reminder'); ?>
                                    </a>
                                </li>
                                <?php } ?>
                                <li>
                                    <a href="#" data-toggle="modal"
                                        data-target="#sales_attach_file"><?= _l('invoice_attach_file'); ?></a>
                                </li>
                                <?php if (staff_can('create', 'projects') && $estimate->project_id == 0) { ?>
                                <li>
                                    <a href="#" data-toggle="modal"
                                        data-target="#estimate_convert_to_project">
                                        <?= _l('estimate_convert_to_project'); ?>
                                    </a>
                                </li>
                                <?php } ?>
                                <li>
                                    <a href="#" onclick="copy_as_save_as_base_data('estimate', '<?= e($estimate->id); ?>'); return false;">
                                        <?= _l('copy_estimate'); ?>
                                    </a>
                                </li>
                                <?php if (staff_can('delete', 'estimates')) { ?>
                                <?php
                           $delete_tooltip = '';
                           if ($estimate->invoiceid !== null) {
                               $delete_tooltip = _l('estimate_delete_not_allowed_already_invoiced');
                           }
                           ?>
                                <li>
                                    <a href="<?= admin_url('estimates/delete/' . $estimate->id); ?>"
                                        class="text-danger delete-text <?= $estimate->invoiceid !== null ? 'disabled' : ' _delete'; ?>"
                                        <?= $estimate->invoiceid !== null ? 'data-toggle="tooltip" title="' . $delete_tooltip . '"' : ''; ?>>
                                        <?= _l('delete_estimate_tooltip'); ?>
                                    </a>
                                </li>
                                <?php } ?>
                            </ul>
                        </div>
                        <?php if ($estimate->invoiceid === null) { ?>
                        <?php if (staff_can('create', 'invoices') && ! empty($estimate->clientid)) { ?>
                        <div class="btn-group pull-right mleft5">
                            <button type="button"
                                class="btn btn-success dropdown-toggle<?= ($estimate->client->active == 0 ? ' disabled' : ''); ?>"
                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <?= _l('estimate_convert_to_invoice'); ?>
                                <span class="caret"></span>
                            </button>
                            <ul class="dropdown-menu">
                                <li><a
                                        href="<?= admin_url('estimates/convert_to_invoice/' . $estimate->id); ?>"><?= _l('estimate_convert_to_invoice'); ?></a>
                                </li>
                                <li class="divider"></li>
                                <li><a href="<?= admin_url('estimates/convert_to_invoice/' . $estimate->id . '?save_as_draft=true'); ?>"><?= _l('convert_and_save_as_draft'); ?></a>
                                </li>
                            </ul>
                        </div>
                        <?php } ?>
                        <?php } else { ?>
                        <a href="<?= admin_url('invoices/list_invoices/' . $estimate->invoiceid); ?>"
                            data-placement="bottom" data-toggle="tooltip"
                            title="<?= _l('estimate_invoiced_date', _dt($estimate->invoiced_date)); ?>"
                            class="btn btn-primary mleft5 pull-right"><?= e(format_invoice_number($estimate->invoiceid)); ?></a>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="clearfix"></div>
            <hr class="hr-panel-separator" />
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="tab_estimate">
                    <div id="estimate-preview" style="direction: rtl; padding: 20px; background: #fff;">
                        
                        <!-- الهيدر الاحترافي المتظبط -->
                        <div class="row" style="margin-bottom: 30px; border-bottom: 3px solid #2563eb; padding-bottom: 20px;">
                            <div class="col-md-4 text-left">
                                <?php 
                                $company_logo = get_option('company_logo');
                                if(!empty($company_logo)) { ?>
                                    <img src="<?= base_url('uploads/company/' . $company_logo); ?>" 
                                         style="max-width: 180px; max-height: 100px;" 
                                         alt="<?= get_option('invoice_company_name'); ?>">
                                <?php } else { ?>
                                    <img src="https://via.placeholder.com/180x80?text=LOGO" 
                                         style="max-width: 180px; max-height: 100px;">
                                <?php } ?>
                            </div>
                            <div class="col-md-8 text-right">
                                <h3 style="color: #2563eb; font-weight: bold; margin-top: 0;">
                                    <?= get_option('invoice_company_name') ?: 'اسم المنشأة'; ?>
                                </h3>
                                <p style="margin-bottom: 2px;">
                                    <strong>العنوان:</strong> <?= get_option('company_address') ?: 'عنوان المنشأة'; ?>
                                </p>
                                <p style="margin-bottom: 2px;">
                                    <strong>السجل التجاري:</strong> <?= get_option('company_vat_number') ?: 'رقم السجل'; ?> 
                                    | <strong>الرقم الضريبي:</strong> <?= get_option('company_vat_number') ?: 'الرقم الضريبي'; ?>
                                </p>
                                <p style="margin-bottom: 2px;">
                                    <strong>رقم التواصل:</strong> <?= get_option('company_phonenumber') ?: 'رقم الهاتف'; ?>
                                </p>
                            </div>
                        </div>

                        <div class="text-center" style="margin-bottom: 30px;">
                            <h2 style="font-weight: bold; text-decoration: underline; color: #333;">عرض سعر</h2>
                        </div>

                        <!-- بيانات العرض والعميل -->
                        <div class="row" style="margin-bottom: 20px;">
                            <div class="col-md-6 text-right">
                                <p><strong>رقم عرض السعر:</strong> <?= e(format_estimate_number($estimate->id)); ?></p>
                                <p><strong>التاريخ:</strong> <?= e(_d($estimate->date)); ?> | <strong>الصلاحية:</strong> <?= e(_d($estimate->expirydate)); ?></p>
                                <p><strong>مندوب المبيعات:</strong> <?= e(get_staff_full_name($estimate->sale_agent)); ?></p>
                                <p><strong>الهاتف:</strong> <?= e($estimate->client->phonenumber); ?></p>
                            </div>
                            <div class="col-md-6 text-right">
                                <div style="background: #f9f9f9; padding: 15px; border: 1px solid #ddd; border-radius: 5px;">
                                    <p style="font-size: 1.1em; color: #2563eb;"><strong>السيد/ة:</strong> <?= e($estimate->client->company); ?></p>
                                    <p><strong>العنوان:</strong> <?= format_customer_info($estimate, 'estimate', 'billing'); ?></p>
                                </div>
                            </div>
                        </div>

                        <!-- جدول الأصناف الاحترافي -->
                        <div class="table-responsive">
                            <table class="table table-bordered" style="border: 2px solid #333;">
                                <thead style="background: #333; color: #fff;">
                                    <tr>
                                        <th class="text-center">#</th>
                                        <th class="text-right">الصنف والوصف</th>
                                        <th class="text-center">الوحدة</th>
                                        <th class="text-center">الكمية</th>
                                        <th class="text-center">سعر الوحدة</th>
                                        <th class="text-center">الضريبة</th>
                                        <th class="text-center">الإجمالي</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 1; foreach($estimate->items as $item) { ?>
                                    <tr>
                                        <td class="text-center"><?= $i++; ?></td>
                                        <td class="text-right">
                                            <strong><?= e($item['description']); ?></strong><br>
                                            <small><?= e($item['long_description']); ?></small>
                                        </td>
                                        <td class="text-center"><?= e($item['unit'] ?: 'حبة'); ?></td>
                                        <td class="text-center"><?= e($item['qty']); ?></td>
                                        <td class="text-center"><?= e(app_format_money($item['rate'], '')); ?></td>
                                        <td class="text-center">15%</td>
                                        <td class="text-center"><?= e(app_format_money($item['rate'] * $item['qty'], '')); ?></td>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- الإجماليات والتفقيط -->
                        <div class="row" style="margin-top: 20px;">
                            <div class="col-md-7">
                                <div style="padding: 15px; border: 2px dashed #2563eb; background: #f0f7ff; border-radius: 5px;">
                                    <p style="margin-bottom: 5px; font-weight: bold; color: #2563eb;">المبلغ كتابةً:</p>
                                    <p style="font-size: 1.2em; font-weight: bold;"><?= formatMoneyArabicFull($estimate->total); ?></p>
                                </div>
                            </div>
                            <div class="col-md-5">
                                <table class="table text-right">
                                    <tr><td style="font-weight: bold;">الإجمالي (قبل الضريبة)</td><td><?= e(app_format_money($estimate->subtotal, '')); ?></td></tr>
                                    <tr><td style="font-weight: bold;">مجموع الخصومات</td><td><?= e(app_format_money($estimate->discount_total, '')); ?></td></tr>
                                    <tr><td style="font-weight: bold;">الإجمالي الخاضع للضريبة</td><td><?= e(app_format_money($estimate->subtotal - $estimate->discount_total, '')); ?></td></tr>
                                    <tr><td style="font-weight: bold;">الضريبة (15%)</td><td><?= e(app_format_money($estimate->total_tax, '')); ?></td></tr>
                                    <tr style="background: #2563eb; color: #fff; font-size: 1.3em; font-weight: bold;"><td>إجمالي المبلغ المستحق</td><td><?= e(app_format_money($estimate->total, '')); ?></td></tr>
                                </table>
                            </div>
                        </div>

                        <?php if ($estimate->clientnote != '') { ?>
                        <div class="col-md-12 mtop15 text-right">
                            <p class="tw-text-neutral-700 tw-font-medium"><?= _l('estimate_note'); ?></p>
                            <div class="tw-text-neutral-500 tw-leading-relaxed">
                                <?= process_text_content_for_display($estimate->clientnote); ?>
                            </div>
                        </div>
                        <?php } ?>
                        <?php if ($estimate->terms != '') { ?>
                        <div class="col-md-12 mtop15 text-right">
                            <p class="tw-text-neutral-700 tw-font-medium"><?= _l('terms_and_conditions'); ?></p>
                            <div class="tw-text-neutral-500 tw-leading-relaxed">
                                <?= process_text_content_for_display($estimate->terms); ?>
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                </div>
                
                <!-- تابات النظام الأصلية -->
                <div role="tabpanel" class="tab-pane" id="tab_tasks">
                    <?php init_relation_tasks_table(['data-new-rel-id' => $estimate->id, 'data-new-rel-type' => 'estimate'], 'tasksFilters'); ?>
                </div>
                <div role="tabpanel" class="tab-pane" id="tab_reminders">
                    <a href="#" data-toggle="modal" class="btn btn-default"
                        data-target=".reminder-modal-estimate-<?= e($estimate->id); ?>"><i
                            class="fa-regular fa-bell"></i>
                        <?= _l('estimate_set_reminder_title'); ?></a>
                    <hr />
                    <?php render_datatable([ _l('reminder_description'), _l('reminder_date'), _l('reminder_staff'), _l('is_notified')], 'reminders'); ?>
                    <?php $this->load->view('admin/includes/modals/reminder', ['id' => $estimate->id, 'name' => 'estimate', 'members' => $members, 'reminder_title' => _l('estimate_set_reminder_title')]); ?>
                </div>
                <div role="tabpanel" class="tab-pane ptop10" id="tab_emails_tracking">
                    <?php $this->load->view('admin/includes/emails_tracking', [
                        'tracked_emails' => get_tracked_emails($estimate->id, 'estimate'),
                    ]); ?>
                </div>
                <div role="tabpanel" class="tab-pane" id="tab_notes">
                    <?= form_open(admin_url('estimates/add_note/' . $estimate->id), ['id' => 'sales-notes', 'class' => 'estimate-notes-form']); ?>
                    <?= render_textarea('description'); ?>
                    <div class="text-right">
                        <button type="submit" class="btn btn-primary mtop15 mbot15">
                            <?= _l('estimate_add_note'); ?>
                        </button>
                    </div>
                    <?= form_close(); ?>
                    <hr />
                    <div class="mtop20" id="sales_notes_area">
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="tab_activity">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="activity-feed">
                                <?php foreach ($activity as $activity) {
                                    $_custom_data = false; ?>
                                <div class="feed-item"
                                    data-sale-activity-id="<?= e($activity['id']); ?>">
                                    <div class="date">
                                        <span class="text-has-action" data-toggle="tooltip"
                                            data-title="<?= e(_dt($activity['date'])); ?>">
                                            <?= e(time_ago($activity['date'])); ?>
                                        </span>
                                    </div>
                                    <div class="text">
                                        <?php if (is_numeric($activity['staffid']) && $activity['staffid'] != 0) { ?>
                                        <a
                                            href="<?= admin_url('profile/' . $activity['staffid']); ?>">
                                            <?= staff_profile_image($activity['staffid'], ['staff-profile-xs-image pull-left mright5']);
                                            ?>
                                        </a>
                                        <?php } ?>
                                        <?php
                                            $additional_data = '';
                                    if (! empty($activity['additional_data'])) {
                                        $additional_data = app_unserialize($activity['additional_data']);
                                        $i               = 0;

                                        foreach ($additional_data as $data) {
                                            if (strpos($data, '<original_status>') !== false) {
                                                $original_status     = get_string_between($data, '<original_status>', '</original_status>');
                                                $additional_data[$i] = format_estimate_status($original_status, '', false);
                                            } elseif (strpos($data, '<new_status>') !== false) {
                                                $new_status          = get_string_between($data, '<new_status>', '</new_status>');
                                                $additional_data[$i] = format_estimate_status($new_status, '', false);
                                            } elseif (strpos($data, '<status>') !== false) {
                                                $status              = get_string_between($data, '<status>', '</status>');
                                                $additional_data[$i] = format_estimate_status($status, '', false);
                                            } elseif (strpos($data, '<custom_data>') !== false) {
                                                $_custom_data = get_string_between($data, '<custom_data>', '</custom_data>');
                                                unset($additional_data[$i]);
                                            }
                                            $i++;
                                        }
                                    }

                                    $_formatted_activity = _l($activity['description'], $additional_data);

                                    if ($_custom_data !== false) {
                                        $_formatted_activity .= ' - ' . $_custom_data;
                                    }

                                    if (! empty($activity['full_name'])) {
                                        $_formatted_activity = e($activity['full_name']) . ' - ' . $_formatted_activity;
                                    }

                                    echo $_formatted_activity;

                                    if (is_admin()) {
                                        echo '<a href="#" class="pull-right text-muted" onclick="delete_sale_activity(' . $activity['id'] . '); return false;"><i class="fa-regular fa-trash-can"></i></a>';
                                    } ?>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane ptop10" id="tab_views">
                    <?php
                  $views_activity = get_views_tracking('estimate', $estimate->id);
if (count($views_activity) === 0) {
    echo '<h4 class="tw-m-0 tw-text-base tw-font-medium tw-text-neutral-500">' . _l('not_viewed_yet', _l('estimate_lowercase')) . '</h4>';
}

foreach ($views_activity as $activity) { ?>
                    <p class="text-success no-margin">
                        <?= _l('view_date') . ': ' . _dt($activity['date']); ?>
                    </p>
                    <p class="text-muted">
                        <?= _l('view_ip') . ': ' . $activity['view_ip']; ?>
                    </p>
                    <hr />
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    init_items_sortable(true);
    init_btn_with_tooltips();
    init_datepicker();
    init_selectpicker();
    init_form_reminder();
    init_tabs_scrollable();
    <?php if ($send_later) { ?>
    schedule_estimate_send( <?= e($estimate->id); ?> );
    <?php } ?>
</script>
<?php $this->load->view('admin/estimates/estimate_send_to_client'); ?>