<?php defined('BASEPATH') or exit('No direct script access allowed');

/**
 * دالة التفقيط الاحترافية - للعميل
 */
if (!function_exists('formatMoneyArabicFull')) {
    function formatMoneyArabicFull($number) {
        $number = number_format($number, 2, '.', '');
        $parts = explode('.', $number);
        $riyal = (int)$parts[0];
        $halala = (int)$parts[1];

        $ones = [
            '', 'واحد', 'اثنان', 'ثلاثة', 'أربعة', 'خمسة', 'ستة', 'سبعة', 'ثمانية', 'تسعة',
            'عشرة', 'أحد عشر', 'اثنا عشر', 'ثلاثة عشر', 'أربعة عشر', 'خمسة عشر', 
            'ستة عشر', 'سبعة عشر', 'ثمانية عشر', 'تسعة عشر'
        ];

        $tens = [
            '', '', 'عشرون', 'ثلاثون', 'أربعون', 'خمسون', 'ستون', 'سبعون', 'ثمانون', 'تسعون'
        ];

        $hundreds = [
            '', 'مائة', 'مائتان', 'ثلاثمائة', 'أربعمائة', 'خمسمائة', 'ستمائة', 'سبعمائة', 'ثمانمائة', 'تسعمائة'
        ];

        $convertHundreds = function($num) use ($ones, $tens, $hundreds) {
            if ($num == 0) return '';
            $str = '';
            $h = floor($num / 100);
            if ($h > 0) {
                $str = $hundreds[$h];
            }
            $remainder = $num % 100;
            if ($remainder > 0 && $remainder < 20) {
                if ($str != '') $str .= ' و';
                $str .= $ones[$remainder];
            } elseif ($remainder >= 20) {
                $t = floor($remainder / 10);
                $o = $remainder % 10;
                if ($str != '') $str .= ' و';
                if ($o > 0) {
                    $str .= $ones[$o] . ' و' . $tens[$t];
                } else {
                    $str .= $tens[$t];
                }
            }
            return $str;
        };

        $convertNumber = function($num) use ($convertHundreds) {
            if ($num == 0) return 'صفر';
            $result = '';
            
            $billion = floor($num / 1000000000);
            if ($billion > 0) {
                if ($billion == 1) {
                    $result .= 'مليار';
                } elseif ($billion == 2) {
                    $result .= 'ملياران';
                } else {
                    $result .= $convertHundreds($billion) . ' مليار';
                }
                $num %= 1000000000;
            }
            
            $million = floor($num / 1000000);
            if ($million > 0) {
                if ($result != '') $result .= ' و';
                if ($million == 1) {
                    $result .= 'مليون';
                } elseif ($million == 2) {
                    $result .= 'مليونان';
                } else {
                    $result .= $convertHundreds($million) . ' مليون';
                }
                $num %= 1000000;
            }
            
            $thousand = floor($num / 1000);
            if ($thousand > 0) {
                if ($result != '') $result .= ' و';
                if ($thousand == 1) {
                    $result .= 'ألف';
                } elseif ($thousand == 2) {
                    $result .= 'ألفان';
                } else {
                    $result .= $convertHundreds($thousand) . ' ألف';
                }
                $num %= 1000;
            }
            
            if ($num > 0) {
                if ($result != '') $result .= ' و';
                $result .= $convertHundreds($num);
            }
            
            return $result;
        };

        $output = 'فقط ' . $convertNumber($riyal) . ' ريال سعودي';
        if ($halala > 0) {
            $output .= ' و' . $convertNumber($halala) . ' هللة';
        }
        $output .= ' لا غير.';
        
        return $output;
    }
}
?>

<div class="mtop15 preview-top-wrapper">
    <div class="row">
        <div class="col-md-3">
            <div class="mbot30">
                <div class="estimate-html-logo">
                    <?= get_dark_company_logo(); ?>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
    </div>
    <div class="top" data-sticky data-sticky-class="preview-sticky-header">
        <div class="container preview-sticky-container">
            <div class="sm:tw-flex sm:tw-justify-between -tw-mx-4">
                <div class="sm:tw-self-end">
                    <h3 class="bold tw-my-0 estimate-html-number">
                        <span class="sticky-visible hide tw-mb-2">
                            <?= e(format_estimate_number($estimate->id)); ?>
                        </span>
                    </h3>
                    <span class="estimate-html-status">
                        <?= format_estimate_status($estimate->status, '', true); ?>
                    </span>
                </div>

                <div class="tw-flex tw-items-end tw-space-x-2 tw-mt-3 sm:tw-mt-0">
                    <?= form_open($this->uri->uri_string(), ['class' => 'action-button']); ?>
                    <button type="submit" name="estimatepdf" class="btn btn-default action-button download"
                        value="estimatepdf">
                        <i class="fa-regular fa-file-pdf"></i>
                        <?= _l('clients_invoice_html_btn_download'); ?>
                    </button>
                    <?= form_close(); ?>
                    <?php if (is_client_logged_in() && has_contact_permission('estimates')) { ?>
                    <a href="<?= site_url('clients/estimates/'); ?>"
                        class="btn btn-default action-button go-to-portal">
                        <?= _l('client_go_to_dashboard'); ?>
                    </a>
                    <?php } ?>
                    <?php
                    // Is not accepted, declined and expired
                  if ($estimate->status != 4 && $estimate->status != 3 && $estimate->status != 5) {
                      echo form_open($this->uri->uri_string(), ['class' => 'action-button']);
                      echo form_hidden('estimate_action', 3);
                      echo '<button type="submit" data-loading-text="' . _l('wait_text') . '" autocomplete="off" class="btn btn-default action-button decline"><i class="fa fa-remove"></i> ' . _l('clients_decline_estimate') . '</button>';
                      echo form_close();
                  }
// Is not accepted, declined and expired
if ($estimate->status != 4 && $estimate->status != 3 && $estimate->status != 5) {
    $can_be_accepted = true;
    if ($identity_confirmation_enabled == '0') {
        echo form_open($this->uri->uri_string(), ['class' => 'action-button']);
        echo form_hidden('estimate_action', 4);
        echo '<button type="submit" data-loading-text="' . _l('wait_text') . '" autocomplete="off" class="btn btn-success action-button accept"><i class="fa fa-check"></i> ' . _l('clients_accept_estimate') . '</button>';
        echo form_close();
    } else {
        echo '<button type="button" id="accept_action" class="btn btn-success action-button accept"><i class="fa fa-check"></i> ' . _l('clients_accept_estimate') . '</button>';
    }
} elseif ($estimate->status == 3) {
    if (($estimate->expirydate >= date('Y-m-d') || ! $estimate->expirydate) && $estimate->status != 5) {
        $can_be_accepted = true;
        if ($identity_confirmation_enabled == '0') {
            echo form_open($this->uri->uri_string(), ['class' => 'action-button']);
            echo form_hidden('estimate_action', 4);
            echo '<button type="submit" data-loading-text="' . _l('wait_text') . '" autocomplete="off" class="btn btn-success action-button accept"><i class="fa fa-check"></i> ' . _l('clients_accept_estimate') . '</button>';
            echo form_close();
        } else {
            echo '<button type="button" id="accept_action" class="btn btn-success action-button accept"><i class="fa fa-check"></i> ' . _l('clients_accept_estimate') . '</button>';
        }
    }
}
?>
                </div>
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
    <div class="panel_s tw-mt-6">
        <div class="panel-body">
            <div class="col-md-10 col-md-offset-1">
                <!-- ═══════════════════════════════════════════════════════════════════ -->
                <!-- التصميم الاحترافي الجديد -->
                <!-- ═══════════════════════════════════════════════════════════════════ -->
                <div id="estimate-preview" style="direction: rtl; padding: 20px; background: #fff;">
                    
                    <!-- الهيدر الاحترافي -->
                    <div class="row" style="margin-bottom: 30px; border-bottom: 3px solid #2563eb; padding-bottom: 20px;">
                        <div class="col-md-4 text-left">
                            <?php 
                            $company_logo = get_option('company_logo');
                            if(!empty($company_logo)) { ?>
                                <img src="<?= base_url('uploads/company/' . $company_logo); ?>" 
                                     style="max-width: 180px; max-height: 100px;" 
                                     alt="<?= get_option('invoice_company_name'); ?>">
                            <?php } else { ?>
                                <?= get_dark_company_logo(); ?>
                            <?php } ?>
                        </div>
                        <div class="col-md-8 text-right">
                            <h3 style="color: #2563eb; font-weight: bold; margin-top: 0;">
                                <?= get_option('companyname') ?: get_option('invoice_company_name') ?: 'اسم المنشأة'; ?>
                            </h3>
                            <p style="margin-bottom: 2px;">
                                <strong>العنوان:</strong> <?= get_option('company_address') ?: get_option('address') ?: 'عنوان المنشأة'; ?>
                            </p>
                            <p style="margin-bottom: 2px;">
                                <strong>السجل التجاري:</strong> <?= get_option('company_id_number') ?: get_option('company_registration_number') ?: 'رقم السجل'; ?> 
                                | <strong>الرقم الضريبي:</strong> <?= get_option('company_vat_number') ?: get_option('companyvat') ?: 'الرقم الضريبي'; ?>
                            </p>
                            <p style="margin-bottom: 2px;">
                                <strong>رقم التواصل:</strong> <?= get_option('company_phonenumber') ?: get_option('phonenumber') ?: 'رقم الهاتف'; ?>
                            </p>
                        </div>
                    </div>

                    <div class="text-center" style="margin-bottom: 30px;">
                        <h2 style="font-weight: bold; text-decoration: underline; color: #333;">عرض سعر</h2>
                    </div>

                    <!-- بيانات العرض والعميل -->
                    <div class="row" style="margin-bottom: 20px;">
                        <div class="col-md-6 text-left">
                            <div style="background: #f9f9f9; padding: 15px; border: 1px solid #ddd; border-radius: 5px;">
                                <p style="margin-bottom: 8px;"><strong>رقم عرض السعر:</strong> <?= e(format_estimate_number($estimate->id)); ?></p>
                                <p style="margin-bottom: 8px;"><strong>التاريخ:</strong> <?= e(_d($estimate->date)); ?></p>
                                <?php if (!empty($estimate->expirydate)) { ?>
                                <p style="margin-bottom: 8px;"><strong>الصلاحية:</strong> <?= e(_d($estimate->expirydate)); ?></p>
                                <?php } ?>
                                <?php if (!empty($estimate->reference_no)) { ?>
                                <p style="margin-bottom: 8px;"><strong>رقم المرجع:</strong> <?= e($estimate->reference_no); ?></p>
                                <?php } ?>
                                <?php if ($estimate->sale_agent && get_option('show_sale_agent_on_estimates') == 1) { ?>
                                <p style="margin-bottom: 8px;"><strong>مندوب المبيعات:</strong> <?= e(get_staff_full_name($estimate->sale_agent)); ?></p>
                                <?php } ?>
                                <?php if ($estimate->project_id && get_option('show_project_on_estimate') == 1) { ?>
                                <p style="margin-bottom: 0;"><strong>المشروع:</strong> <?= e(get_project_name_by_id($estimate->project_id)); ?></p>
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-6 text-right">
                            <div style="background: #f0f7ff; padding: 15px; border: 2px solid #2563eb; border-radius: 5px;">
                                <p style="font-size: 1.1em; color: #2563eb; margin-bottom: 10px;"><strong>بيانات العميل</strong></p>
                                <div style="color: #333;">
                                    <?= format_customer_info($estimate, 'estimate', 'billing', true); ?>
                                </div>
                                <?php if ($estimate->include_shipping == 1 && $estimate->show_shipping_on_estimate == 1) { ?>
                                <hr style="margin: 10px 0;">
                                <p style="font-weight: bold; margin-bottom: 5px; color: #2563eb;">عنوان الشحن:</p>
                                <div style="color: #555;">
                                    <?= format_customer_info($estimate, 'estimate', 'shipping'); ?>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>

                    <!-- جدول الأصناف -->
                    <div class="table-responsive">
                        <?php $items = get_items_table_data($estimate, 'estimate'); ?>
                        <?= $items->table(); ?>
                    </div>

                    <!-- الإجماليات والتفقيط -->
                    <div class="row" style="margin-top: 20px;">
                        <div class="col-md-7">
                            <div style="padding: 15px; border: 2px dashed #2563eb; background: #f0f7ff; border-radius: 5px;">
                                <p style="margin-bottom: 5px; font-weight: bold; color: #2563eb;">المبلغ كتابةً:</p>
                                <p style="font-size: 1.2em; font-weight: bold;"><?= formatMoneyArabicFull($estimate->total); ?></p>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <table class="table text-right">
                                <tr>
                                    <td style="font-weight: bold;">الإجمالي (قبل الضريبة)</td>
                                    <td><?= e(app_format_money($estimate->subtotal, $estimate->currency_name)); ?></td>
                                </tr>
                                <?php if (is_sale_discount_applied($estimate)) { ?>
                                <tr>
                                    <td style="font-weight: bold;">الخصم
                                        <?php if (is_sale_discount($estimate, 'percent')) { ?>
                                        (<?= e(app_format_number($estimate->discount_percent, true)); ?>%)
                                        <?php } ?>
                                    </td>
                                    <td><?= e('-' . app_format_money($estimate->discount_total, $estimate->currency_name)); ?></td>
                                </tr>
                                <?php } ?>
                                <tr>
                                    <td style="font-weight: bold;">الإجمالي الخاضع للضريبة</td>
                                    <td><?= e(app_format_money($estimate->subtotal - $estimate->discount_total, $estimate->currency_name)); ?></td>
                                </tr>
                                <?php foreach ($items->taxes() as $tax) { ?>
                                <tr>
                                    <td style="font-weight: bold;"><?= e($tax['taxname']); ?> (<?= e(app_format_number($tax['taxrate'])); ?>%)</td>
                                    <td><?= e(app_format_money($tax['total_tax'], $estimate->currency_name)); ?></td>
                                </tr>
                                <?php } ?>
                                <?php if ((int) $estimate->adjustment != 0) { ?>
                                <tr>
                                    <td style="font-weight: bold;">التعديل</td>
                                    <td><?= e(app_format_money($estimate->adjustment, $estimate->currency_name)); ?></td>
                                </tr>
                                <?php } ?>
                                <tr style="background: #2563eb; color: #fff; font-size: 1.3em; font-weight: bold;">
                                    <td>إجمالي المبلغ المستحق</td>
                                    <td><?= e(app_format_money($estimate->total, $estimate->currency_name)); ?></td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <?php if (count($estimate->attachments) > 0 && $estimate->visible_attachments_to_customer_found == true) { ?>
                    <div class="clearfix"></div>
                    <hr />
                    <p class="tw-text-neutral-700 tw-font-medium">
                        <?= _l('estimate_files'); ?>
                    </p>
                    <?php foreach ($estimate->attachments as $attachment) {
                        if ($attachment['visible_to_customer'] == 0) {
                            continue;
                        }
                        $attachment_url = site_url('download/file/sales_attachment/' . $attachment['attachment_key']);
                        if (!empty($attachment['external'])) {
                            $attachment_url = $attachment['external_link'];
                        } ?>
                    <div class="mbot15 row inline-block full-width">
                        <div class="col-md-8">
                            <i class="<?= get_mime_class($attachment['filetype']); ?>"></i>
                            <a href="<?= e($attachment_url); ?>"><?= e($attachment['file_name']); ?></a>
                            <br />
                            <small class="text-muted"><?= e($attachment['filetype']); ?></small>
                        </div>
                    </div>
                    <?php } ?>
                    <?php } ?>

                    <?php if (!empty($estimate->clientnote)) { ?>
                    <div class="col-md-12 mtop15 text-right">
                        <p class="tw-text-neutral-700 tw-font-medium"><?= _l('estimate_note'); ?></p>
                        <div class="tw-text-neutral-500 tw-leading-relaxed">
                            <?= process_text_content_for_display($estimate->clientnote); ?>
                        </div>
                    </div>
                    <?php } ?>
                    
                    <?php if (!empty($estimate->terms)) { ?>
                    <div class="col-md-12 mtop15 text-right">
                        <p class="tw-text-neutral-700 tw-font-medium"><?= _l('terms_and_conditions'); ?></p>
                        <div class="tw-text-neutral-500 tw-leading-relaxed">
                            <?= process_text_content_for_display($estimate->terms); ?>
                        </div>
                    </div>
                    <?php } ?>
                </div>
                <!-- نهاية التصميم الاحترافي -->
            </div>
        </div>
    </div>
    <?php
   if ($identity_confirmation_enabled == '1' && $can_be_accepted) {
       get_template_part('identity_confirmation_form', ['formData' => form_hidden('estimate_action', 4)]);
   }
?>
    <script>
        $(function() {
            new Sticky('[data-sticky]');
            $('.select-item').on('change', function() {
                const $el = $(this);
                const isChecked = $el.prop('checked') ? 1 : 0;
                const itemId = $el.closest('tr').data('item-id');

                $.post(window.location.href, {
                    item_id: itemId,
                    choosen: isChecked,
                    action: 'estimate_item_selection_changed'
                }).done(function() {
                    window.location.reload();
                });
            });
        })
    </script>