<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * دالة التفقيط الاحترافية للـ PDF
 */
if (!function_exists('formatMoneyArabicFullPDF')) {
    function formatMoneyArabicFullPDF($number) {
        $number = number_format($number, 2, '.', '');
        $parts = explode('.', $number);
        $riyal = (int)$parts[0];
        $halala = (int)$parts[1];

        $ones = [
            '', 'واحد', 'اثنان', 'ثلاثة', 'أربعة', 'خمسة', 'ستة', 'سبعة', 'ثمانية', 'تسعة',
            'عشرة', 'أحد عشر', 'اثنا عشر', 'ثلاثة عشر', 'أربعة عشر', 'خمسة عشر', 
            'ستة عشر', 'سبعة عشر', 'ثمانية عشر', 'تسعة عشر'
        ];

        $tens = [
            '', '', 'عشرون', 'ثلاثون', 'أربعون', 'خمسون', 'ستون', 'سبعون', 'ثمانون', 'تسعون'
        ];

        $hundreds = [
            '', 'مائة', 'مائتان', 'ثلاثمائة', 'أربعمائة', 'خمسمائة', 'ستمائة', 'سبعمائة', 'ثمانمائة', 'تسعمائة'
        ];

        $convertHundreds = function($num) use ($ones, $tens, $hundreds) {
            if ($num == 0) return '';
            $str = '';
            $h = floor($num / 100);
            if ($h > 0) {
                $str = $hundreds[$h];
            }
            $remainder = $num % 100;
            if ($remainder > 0 && $remainder < 20) {
                if ($str != '') $str .= ' و';
                $str .= $ones[$remainder];
            } elseif ($remainder >= 20) {
                $t = floor($remainder / 10);
                $o = $remainder % 10;
                if ($str != '') $str .= ' و';
                if ($o > 0) {
                    $str .= $ones[$o] . ' و' . $tens[$t];
                } else {
                    $str .= $tens[$t];
                }
            }
            return $str;
        };

        $convertNumber = function($num) use ($convertHundreds) {
            if ($num == 0) return 'صفر';
            $result = '';
            
            $billion = floor($num / 1000000000);
            if ($billion > 0) {
                if ($billion == 1) {
                    $result .= 'مليار';
                } elseif ($billion == 2) {
                    $result .= 'ملياران';
                } else {
                    $result .= $convertHundreds($billion) . ' مليار';
                }
                $num %= 1000000000;
            }
            
            $million = floor($num / 1000000);
            if ($million > 0) {
                if ($result != '') $result .= ' و';
                if ($million == 1) {
                    $result .= 'مليون';
                } elseif ($million == 2) {
                    $result .= 'مليونان';
                } else {
                    $result .= $convertHundreds($million) . ' مليون';
                }
                $num %= 1000000;
            }
            
            $thousand = floor($num / 1000);
            if ($thousand > 0) {
                if ($result != '') $result .= ' و';
                if ($thousand == 1) {
                    $result .= 'ألف';
                } elseif ($thousand == 2) {
                    $result .= 'ألفان';
                } else {
                    $result .= $convertHundreds($thousand) . ' ألف';
                }
                $num %= 1000;
            }
            
            if ($num > 0) {
                if ($result != '') $result .= ' و';
                $result .= $convertHundreds($num);
            }
            
            return $result;
        };

        $output = 'فقط ' . $convertNumber($riyal) . ' ريال سعودي';
        if ($halala > 0) {
            $output .= ' و' . $convertNumber($halala) . ' هللة';
        }
        $output .= ' لا غير.';
        
        return $output;
    }
}

$dimensions = $pdf->getPageDimensions();

// الهيدر الاحترافي
$pdf->SetFont($font_name, 'B', 16);

// بيانات الشركة
$company_name = get_option('companyname') ?: get_option('invoice_company_name') ?: 'اسم المنشأة';
$company_address = get_option('company_address') ?: get_option('address') ?: 'عنوان المنشأة';
$company_vat = get_option('company_vat_number') ?: get_option('companyvat') ?: 'الرقم الضريبي';
$company_phone = get_option('company_phonenumber') ?: get_option('phonenumber') ?: 'رقم الهاتف';
$company_id = get_option('company_id_number') ?: get_option('company_registration_number') ?: 'رقم السجل';

// اللوجو
$logo_path = get_option('company_logo');
if (!empty($logo_path)) {
    $logo_url = FCPATH . 'uploads/company/' . $logo_path;
    if (file_exists($logo_url)) {
        $pdf->Image($logo_url, 15, 10, 40, 0, '', '', '', false, 300, '', false, false, 0);
    }
}

// اسم المنشأة والبيانات على اليمين
$pdf->SetXY($dimensions['wk'] - 120, 15);
$pdf->SetFont($font_name, 'B', 14);
$pdf->SetTextColor(37, 99, 235);
$pdf->Cell(100, 8, $company_name, 0, 1, 'R');

$pdf->SetFont($font_name, '', 10);
$pdf->SetTextColor(0, 0, 0);
$pdf->SetX($dimensions['wk'] - 120);
$pdf->Cell(100, 6, 'العنوان: ' . $company_address, 0, 1, 'R');
$pdf->SetX($dimensions['wk'] - 120);
$pdf->Cell(100, 6, 'السجل التجاري: ' . $company_id, 0, 1, 'R');
$pdf->SetX($dimensions['wk'] - 120);
$pdf->Cell(100, 6, 'الرقم الضريبي: ' . $company_vat, 0, 1, 'R');
$pdf->SetX($dimensions['wk'] - 120);
$pdf->Cell(100, 6, 'رقم التواصل: ' . $company_phone, 0, 1, 'R');

$pdf->Ln(10);

// عنوان "فاتورة"
$pdf->SetFont($font_name, 'B', 18);
$pdf->Cell(0, 10, 'فاتورة', 0, 1, 'C');
$pdf->Ln(5);

// بيانات الفاتورة والعميل
$pdf->SetFont($font_name, 'B', 10);

// صندوق معلومات الفاتورة (على اليسار)
$y_position = $pdf->GetY();
$pdf->SetFillColor(249, 249, 249);
$pdf->SetXY(15, $y_position);
$pdf->Cell(85, 6, '', 0, 1, 'R', false);

$pdf->SetXY(15, $y_position);
$pdf->SetFont($font_name, 'B', 10);
$pdf->Cell(85, 6, 'رقم الفاتورة: ' . $invoice_number, 0, 1, 'R', false);

$pdf->SetX(15);
$pdf->SetFont($font_name, '', 9);
$pdf->Cell(85, 5, 'التاريخ: ' . _d($invoice->date), 0, 1, 'R', false);

if (!empty($invoice->duedate)) {
    $pdf->SetX(15);
    $pdf->Cell(85, 5, 'الاستحقاق: ' . _d($invoice->duedate), 0, 1, 'R', false);
}

if ($invoice->sale_agent && get_option('show_sale_agent_on_invoices') == 1) {
    $pdf->SetX(15);
    $pdf->Cell(85, 5, 'مندوب المبيعات: ' . get_staff_full_name($invoice->sale_agent), 0, 1, 'R', false);
}

if ($invoice->project_id && get_option('show_project_on_invoice') == 1) {
    $pdf->SetX(15);
    $pdf->Cell(85, 5, 'المشروع: ' . get_project_name_by_id($invoice->project_id), 0, 1, 'R', false);
}

// صندوق معلومات العميل (على اليمين)
$pdf->SetY($y_position);
$pdf->SetFillColor(240, 247, 255);
$pdf->SetXY($dimensions['wk'] - 100, $y_position);
$pdf->SetFont($font_name, 'B', 10);
$pdf->SetTextColor(37, 99, 235);
$pdf->Cell(85, 6, 'بيانات العميل', 1, 1, 'R', true);

$pdf->SetX($dimensions['wk'] - 100);
$pdf->SetFont($font_name, '', 9);
$pdf->SetTextColor(0, 0, 0);
$pdf->SetFillColor(255, 255, 255);
$client_name = $invoice->client ? $invoice->client->company : '';
$pdf->Cell(85, 5, 'السيد/ة: ' . $client_name, 1, 1, 'R', true);

$pdf->SetX($dimensions['wk'] - 100);
$client_address = format_customer_info($invoice, 'invoice', 'billing', false);
$pdf->MultiCell(85, 5, 'العنوان: ' . strip_tags($client_address), 1, 'R', true);

$pdf->Ln(4);

// جدول الأصناف
$items = get_items_table_data($invoice, 'invoice', 'pdf');
$tblhtml = $items->table();
$pdf->writeHTML($tblhtml, true, false, false, false, '');

$pdf->Ln(8);

// جدول الإجماليات - بنفس تنسيق الـ estimate
$tbltotal = '<table cellpadding="6" style="font-size:' . ($font_size + 2) . 'px; width: 100%;">';

// الإجمالي (قبل الضريبة)
$tbltotal .= '<tr>
    <td width="60%"></td> 
    <td align="left" width="15%" style="border-bottom: 1px solid #eee;">' . app_format_money($invoice->subtotal, $invoice->currency_name) . '</td>
    <td align="right" width="25%" style="border-bottom: 1px solid #eee;"><strong>الإجمالي (قبل الضريبة)</strong></td>
</tr>';

// مجموع الخصومات
if (is_sale_discount_applied($invoice)) {
    $tbltotal .= '<tr>
        <td width="60%"></td>
        <td align="left" width="15%" style="border-bottom: 1px solid #eee;">' . app_format_money($invoice->discount_total, $invoice->currency_name) . '</td>
        <td align="right" width="25%" style="border-bottom: 1px solid #eee;"><strong>مجموع الخصومات</strong></td>
    </tr>';
}

// الإجمالي الخاضع للضريبة
$tbltotal .= '<tr>
    <td width="60%"></td>
    <td align="left" width="15%" style="border-bottom: 1px solid #eee;">' . app_format_money($invoice->subtotal - $invoice->discount_total, $invoice->currency_name) . '</td>
    <td align="right" width="25%" style="border-bottom: 1px solid #eee;"><strong>الإجمالي الخاضع للضريبة</strong></td>
</tr>';

// الضريبة
foreach ($items->taxes() as $tax) {
    $tbltotal .= '<tr>
        <td width="60%"></td>
        <td align="left" width="15%" style="border-bottom: 1px solid #eee;">' . app_format_money($tax['total_tax'], $invoice->currency_name) . '</td>
        <td align="right" width="25%" style="border-bottom: 1px solid #eee;"><strong>' . $tax['taxname'] . ' (' . app_format_number($tax['taxrate']) . '%)</strong></td>
    </tr>';
}

// التعديل
if ((int) $invoice->adjustment != 0) {
    $tbltotal .= '<tr>
        <td width="60%"></td>
        <td align="left" width="15%" style="border-bottom: 1px solid #eee;">' . app_format_money($invoice->adjustment, $invoice->currency_name) . '</td>
        <td align="right" width="25%" style="border-bottom: 1px solid #eee;"><strong>التعديل</strong></td>
    </tr>';
}

// إجمالي المبلغ المستحق (السطر الأزرق)
$tbltotal .= '<tr>
    <td width="60%"></td>
    <td align="left" width="15%" style="background-color:#2563eb; color:#fff;"><strong>' . app_format_money($invoice->total, $invoice->currency_name) . '</strong></td>
    <td align="right" width="25%" style="background-color:#2563eb; color:#fff;"><strong>إجمالي المبلغ المستحق</strong></td>
</tr>';

// المبلغ المدفوع
if (count($invoice->payments) > 0 && get_option('show_total_paid_on_invoice') == 1) {
    $tbltotal .= '<tr>
        <td width="60%"></td>
        <td align="left" width="15%" style="background-color:#d4edda; border-bottom: 1px solid #eee;">' . app_format_money(sum_from_table(db_prefix() . 'invoicepaymentrecords', [
            'field' => 'amount',
            'where' => ['invoiceid' => $invoice->id],
        ]), $invoice->currency_name) . '</td>
        <td align="right" width="25%" style="background-color:#d4edda; border-bottom: 1px solid #eee;"><strong>المبلغ المدفوع</strong></td>
    </tr>';
}

// الائتمانات المطبقة
if (get_option('show_credits_applied_on_invoice') == 1 && $credits_applied = total_credits_applied_to_invoice($invoice->id)) {
    $tbltotal .= '<tr>
        <td width="60%"></td>
        <td align="left" width="15%" style="border-bottom: 1px solid #eee;">' . app_format_money($credits_applied, $invoice->currency_name) . '</td>
        <td align="right" width="25%" style="border-bottom: 1px solid #eee;"><strong>الائتمانات المطبقة</strong></td>
    </tr>';
}

// المبلغ المتبقي
if (get_option('show_amount_due_on_invoice') == 1 && $invoice->status != Invoices_model::STATUS_CANCELLED) {
    $bg_color = $invoice->total_left_to_pay > 0 ? '#f8d7da' : '#d4edda';
    $tbltotal .= '<tr>
        <td width="60%"></td>
        <td align="left" width="15%" style="background-color:' . $bg_color . ';"><strong>' . app_format_money($invoice->total_left_to_pay, $invoice->currency_name) . '</strong></td>
        <td align="right" width="25%" style="background-color:' . $bg_color . ';"><strong>المبلغ المتبقي</strong></td>
    </tr>';
}

$tbltotal .= '</table>';

$pdf->writeHTML($tbltotal, true, false, false, false, '');

// التفقيط
$pdf->Ln(6);
$pdf->SetFont($font_name, 'B', 11);
$pdf->SetFillColor(240, 247, 255);
$pdf->SetTextColor(37, 99, 235);
$pdf->Cell(0, 8, 'المبلغ كتابةً:', 1, 1, 'R', true);
$pdf->SetFont($font_name, '', 10);
$pdf->SetTextColor(0, 0, 0);
$pdf->MultiCell(0, 8, formatMoneyArabicFullPDF($invoice->total), 1, 'R', false);

$pdf->Ln(4);

// جدول المدفوعات
if (count($invoice->payments) > 0 && get_option('show_transactions_on_invoice_pdf') == 1) {
    $pdf->SetFont($font_name, 'B', $font_size);
    $pdf->Cell(0, 0, 'المدفوعات المستلمة:', 0, 1, 'R', 0, '', 0);
    $pdf->SetFont($font_name, '', $font_size);
    $pdf->Ln(4);
    
    $border = 'border-bottom-color:#000000;border-bottom-width:1px;border-bottom-style:solid;';
    $tblhtml = '<table width="100%" bgcolor="#fff" cellspacing="0" cellpadding="5" border="0">
        <tr height="20" style="color:#000;border:1px solid #000;">
        <th width="25%;" style="' . $border . '">رقم الدفع</th>
        <th width="25%;" style="' . $border . '">طريقة الدفع</th>
        <th width="25%;" style="' . $border . '">التاريخ</th>
        <th width="25%;" style="' . $border . '">المبلغ</th>
    </tr>';
    $tblhtml .= '<tbody>';

    foreach ($invoice->payments as $payment) {
        $payment_name = $payment['name'];
        if (!empty($payment['paymentmethod'])) {
            $payment_name .= ' - ' . $payment['paymentmethod'];
        }
        $tblhtml .= '<tr>
            <td>' . $payment['paymentid'] . '</td>
            <td>' . $payment_name . '</td>
            <td>' . _d($payment['date']) . '</td>
            <td>' . app_format_money($payment['amount'], $invoice->currency_name) . '</td>
        </tr>';
    }
    $tblhtml .= '</tbody></table>';
    $pdf->writeHTML($tblhtml, true, false, false, false, '');
}

// طرق الدفع غير المباشرة
if (found_invoice_mode($payment_modes, $invoice->id, true, true)) {
    $pdf->Ln(4);
    $pdf->SetFont($font_name, 'B', $font_size);
    $pdf->Cell(0, 0, 'طرق الدفع المتاحة:', 0, 1, 'R', 0, '', 0);
    $pdf->SetFont($font_name, '', $font_size);

    foreach ($payment_modes as $mode) {
        if (is_numeric($mode['id'])) {
            if (!is_payment_mode_allowed_for_invoice($mode['id'], $invoice->id)) {
                continue;
            }
        }
        if (isset($mode['show_on_pdf']) && $mode['show_on_pdf'] == 1) {
            $pdf->Ln(1);
            $pdf->Cell(0, 0, $mode['name'], 0, 1, 'R', 0, '', 0);
            $pdf->Ln(2);
            $pdf->writeHTMLCell('', '', '', '', $mode['description'], 0, 1, false, true, 'R', true);
        }
    }
}

// ملاحظات العميل
if (!empty($invoice->clientnote)) {
    $pdf->Ln(4);
    $pdf->SetFont($font_name, 'B', $font_size);
    $pdf->Cell(0, 0, _l('invoice_note'), 0, 1, 'R', 0, '', 0);
    $pdf->SetFont($font_name, '', $font_size);
    $pdf->Ln(2);
    $pdf->writeHTMLCell('', '', '', '', $invoice->clientnote, 0, 1, false, true, 'R', true);
}

// الشروط والأحكام
if (!empty($invoice->terms)) {
    $pdf->Ln(4);
    $pdf->SetFont($font_name, 'B', $font_size);
    $pdf->Cell(0, 0, _l('terms_and_conditions') . ':', 0, 1, 'R', 0, '', 0);
    $pdf->SetFont($font_name, '', $font_size);
    $pdf->Ln(2);
    $pdf->writeHTMLCell('', '', '', '', $invoice->terms, 0, 1, false, true, 'R', true);
}