t<?php

defined('BASEPATH') or exit('No direct script access allowed');

class FiniexApi extends ClientsController
{
	
	private $my_api_settings = [
						'api_user_table'=>'api_finiex_users',
						'api_log_table'=>'api_finiex_logs',
						'prefix_id'=>'2',
						'prefix_name'=>'api_',
						'prefix_pass'=>'7sp',
						'prefix_token'=>'d6t',
						'insert_status_id'=> '5',		//الحاله:  عميل محتمل الموقع الالكتروني
						'insert_source_id'=> '6',		//المصدر: الموقع الالكتروني
						];
						
    public function index()
    {
        show_404();
    }
	
/*
Required Tables

CREATE TABLE IF NOT EXISTS `tblapi_finiex_logs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `log_data` text NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `tblapi_finiex_users` (
  `id` int(11) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `desc` varchar(50) DEFAULT NULL COMMENT 'الصفه',
  `login_name` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `token` varchar(255) DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `login_name` (`login_name`),
  KEY `token` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tblapi_finiex_users` (`id`, `name`, `desc`, `login_name`, `password`, `token`, `status`, `created_at`, `updated_at`) VALUES
	(2506, 'API', NULL, 'api_user_1623', '$2a$08$XPScFFEFVUcp2MYi1xN/0evQe0l3EY34TS9jE5t3TqzYyoKH/cjZO', 'd6t6ce2b0a4bc84b9ad5c2d43b978895a7bb20b525082f84ddf1b45faa10e02296e', 1, '2021-10-17 02:47:25', '2021-10-19 18:03:40');

*/

	public function api_login($key){
		//echo get_staff_user_id();
		//exit;
		/*
        $this->load->model('leads_model');
        $form = $this->leads_model->get_form([
            'form_key' => $key,
            ]);
			
        if (!$form) {
            show_404();
        }
		
        // Change the locale so the validation loader function can load
        // the proper localization file
        $GLOBALS['locale'] = get_locale_key($form->language);
		
        $data['form_fields'] = json_decode($form->form_data);
		
        if (!$data['form_fields']) {
            $data['form_fields'] = [];
        }
*/
		//print_r($this->input->post();;
		//echo '<br>';
		//echo $this->input->post('login_name');
		//exit;
        if($this->input->post('key')){				//يتم ايقافهم مؤقتا حتى يتم التعام مع post
            if ($this->input->post('key') == $key) {
				$post_data = $this->input->post();
				$field = 'log_id';
                if (!isset($post_data[$field]) || isset($post_data[$field]) && empty($post_data[$field])) {
					$this->output->set_status_header(422);
					die;
				}
				$api_userid = $post_data[$field];
				
				$field = 'log_name';
                if (!isset($post_data[$field]) || isset($post_data[$field]) && empty($post_data[$field])) {
					$this->output->set_status_header(422);
					die;
				}
				$api_login_name = $post_data[$field];
				
				$field = 'log_pass';
                if (!isset($post_data[$field]) || isset($post_data[$field]) && empty($post_data[$field])) {
					$this->output->set_status_header(422);
					die;
				}
				$api_password = $post_data[$field];

				//$api_userid = "506";
				//$api_login_name = "api_user_1623";
				//$api_password = "e5090024c093405f39f4084aab37dc5b";
				
				//يفحص تسجيل الدخول بشكل صحيح
				if(!$this->checkApiLogin($api_userid, $api_login_name, $api_password)){
					show_404();
					exit;
				}
				$token = $this->apiUpdateToken($api_userid);
				if(!$token){
					show_404();
					exit;					
				}
				echo $token;
				return true;
			}
		}
		
		show_404();
	}
	
	
	private function apiUpdatePassword($api_userid){
		if(empty($api_userid)){return false;}
		
		$new_pass_key = app_generate_hash();
		
		//$password = md5('spider');
		//$update_password = 'spider';
        $password = app_hash_password($new_pass_key);
		
        $table    = $this->my_api_settings['api_user_table'];
        $this->db->where('id', $this->my_api_settings['prefix_id'].$api_userid);
        $this->db->update(db_prefix() . $table, [
            'password' => $password,
        ]);
        if ($this->db->affected_rows() > 0) {
            $this->api_insert_log('Api Update Password [Api User ID: ' . $api_userid . ', IP: ' . $this->input->ip_address() . ']');
            $this->db->where('id', $api_userid);
            $this->db->update($table);
        }
		return $this->my_api_settings['prefix_pass'].$password;
	}
	
	
	private function apiUpdateToken($api_userid){
		//return false;
		if(empty($api_userid)){return false;}
		
		$new_token = md5(app_generate_hash()).app_generate_hash();
		
        $table    = $this->my_api_settings['api_user_table'];
        $this->db->where('id', $this->my_api_settings['prefix_id'].$api_userid);
        $this->db->update(db_prefix() . $table, [
            'token' => $this->my_api_settings['prefix_token'].$new_token,
        ]);
        if ($this->db->affected_rows() > 0) {
			return $new_token;
        }
		return false;
	}
	
	private function checkApiLogin($api_userid, $login_name, $password){
        if ((!empty($api_userid)) and (!empty($login_name)) and (!empty($password))) {
			$api_password = $password;
			if(substr($api_password, 0, strlen($this->my_api_settings['prefix_pass'])) != $this->my_api_settings['prefix_pass']){
				return false;
			}
			$api_password = substr($api_password, strlen($this->my_api_settings['prefix_pass']));
			
			
            $table = db_prefix() . $this->my_api_settings['api_user_table'];
            $this->db->where('id', $this->my_api_settings['prefix_id'].$api_userid);
            $this->db->where('login_name', $this->my_api_settings['prefix_name'].$login_name);
            $api_user = $this->db->get($table)->row();
            if ($api_user) {
                // login_name is okey lets check the password now
                if (!app_hasher()->CheckPassword($api_password, $api_user->password)) {
                    hooks()->do_action('failed_login_attempt', [
                        'api_user'            => $api_user,
                    ]);

                    $this->api_insert_log('Failed Api Login Attempt [Login_Name: ' . $login_name . ', IP: ' . $this->input->ip_address() . ']');

                    // Password failed, return
                    return false;
                }
            } else {

                hooks()->do_action('non_existent_user_login_attempt', [
                        'login_name'           => $login_name,
                ]);

                $this->api_insert_log('Non Existing Api User Tried to Login [login_name: ' . $login_name . ', IP: ' . $this->input->ip_address() . ']');

                return false;
            }

            if ($api_user->status != 1) {
                hooks()->do_action('inactive_user_login_attempt', [
                        'user'            => $api_user,
                ]);
                $this->api_insert_log('Inactive Api User Tried to Login [login_name: ' . $login_name . ', IP: ' . $this->input->ip_address() . ']');

                return [
                    'memberinactive' => true,
                ];
            }
			return true;
		}
		return false;
	}

	
	private function checkApiToken($api_userid, $token){
        if ((!empty($api_userid)) and (!empty($token))) {
			//updated_at
            $table = db_prefix() . $this->my_api_settings['api_user_table'];
            $this->db->where('id', $this->my_api_settings['prefix_id'].$api_userid);
            $this->db->where('token', $this->my_api_settings['prefix_token'].$token);
            
			//$this->db->where("updated_at >= '". date('Y-m-d', strtotime('-1 day'))."'");
			
            $api_user = $this->db->get($table)->row();
            if (!$api_user) {
                $this->api_insert_log('Non Existing Api User Tried to Token [token: ' . $token . ', IP: ' . $this->input->ip_address() . ']');
                return false;
            }
            if ($api_user->status != 1) {
                $this->api_insert_log('Inactive Api User Tried to Token [token: ' . $token . ', IP: ' . $this->input->ip_address() . ']');

                return [
                    'memberinactive' => true,
                ];
            }
			return true;
		}
		return false;
	}
	
	
    public function api_send_data($key)
    {
		/*
		//############################
		//############################			تغيير كلمه المرور
		//############################
		
		$checkUpdatePassword = $this->apiUpdatePassword($api_userid);
		if($checkUpdatePassword){
			echo 'good update user: '.$checkUpdatePassword;
			exit;
		}
		*/
        if($this->input->post('key')){			
            if ($this->input->post('key') == $key) {
				$post_data = $this->input->post();
				$field = 'log_id';
                if (!isset($post_data[$field]) || isset($post_data[$field]) && empty($post_data[$field])) {
					$this->output->set_status_header(422);
					die;
				}
				$api_userid = $post_data[$field];
				
				
				$field = '_token';
                if (!isset($post_data[$field]) || isset($post_data[$field]) && empty($post_data[$field])) {
					$this->output->set_status_header(422);
					die;
				}
				$api_token = $post_data[$field];

				if(!$this->checkApiToken($api_userid, $api_token)){
					show_404();
					exit;
				}

				$this->api_add_lead($post_data);
			}
        }

		show_404();
    }

    /**
     * Add new lead to database
     * @param mixed $data lead data
     * @return mixed false || leadid
     */
    private function api_add_lead($send_data)
    {
		
		$name = $this->checkFieldString($send_data['name'] ?? '', 'str');
		$phone = $this->checkFieldString($send_data['phone'] ?? 0, 'int');
		$email = $this->checkFieldString($send_data['email'] ?? '', 'email');
		$company = $this->checkFieldString($send_data['company'] ?? '', 'str');
		$budget = $this->checkFieldString($send_data['budget'] ?? 0, 'dec');
		$iso3 = $this->checkFieldString($send_data['iso3'] ?? '', 'wrd');		//حروف او رمز الدوله المكون من ثلاثه حروف انجليزيه كبيره
		$city = $this->checkFieldString($send_data['city'] ?? '', 'str');
		$state = $this->checkFieldString($send_data['state'] ?? '', 'str');
		$address = $this->checkFieldString($send_data['address'] ?? '', 'str');
		$website = $this->checkFieldString($send_data['website'] ?? '', 'url');
		$others = $this->checkFieldString($send_data['others'] ?? '', 'txt');
		
		if(strlen($name) < 10){
			$this->sendApiError('short name', 102);
		} else if(strlen($name) > 191){
			$this->sendApiError('long name', 103);
		}
		if(count(explode(' ', $name))<2){
			$this->sendApiError('name syntax error', 101);
		}

		//#################################
		//يفحص الاسم هل هو موجود من قبل
		//#################################
		$table = db_prefix() . 'leads';
		$this->db->where('name', $name);
		$check_row = $this->db->get($table)->row();
		if ($check_row){
			$check_id = $check_row->id ?? 0;
			if($check_id){
				$this->sendApiError('The name already exists', 105);
			}
		}

		if($phone < 1){
			$this->sendApiError('error in phone number', 111);			
		}
		if(strlen($phone) < 9){
			$this->sendApiError('short phone number', 112);
		}

		if(strlen($phone) > 15){
			$this->sendApiError('long phone number', 113);
		}

		//#################################
		//يفحص الاسم هل هو موجود من قبل
		//#################################
		$table = db_prefix() . 'leads';
		$this->db->where('phonenumber', $phone);
		$check_row = $this->db->get($table)->row();
		if ($check_row){
			$check_id = $check_row->id ?? 0;
			if($check_id){
				$this->sendApiError('The phone number already exists', 115);
			}
		}
		
		if(strlen($email) > 100){
			$this->sendApiError('long email', 123);
		}
		
		if(strlen($company) > 191){
			$this->sendApiError('long company name', 133);
		}
		
		if(strlen($city) > 100){
			$city = substr($city, 0, 99);
		}
		if(strlen($state) > 100){
			$state = substr($state, 0, 99);
		}

		if(strlen($address) > 100){
			$address = substr($address, 0, 99);
		}

		if(strlen($website) > 150){
			$this->sendApiError('long website url', 143);
		}
		
		$description = '';
		if($budget !=''){
			if($budget>0){
				if($description !=''){$description .= chr(13);}
				$description .= 'budget: '.$budget;
			}
		}
		if($others !=''){
			if($description !=''){$description .= chr(13);}
			$description .= $others;
		}
		
		$country = 0;
		if($iso3 !=''){
			if(strlen($iso3) != 3){$iso3 = '';}
		}
		if($iso3 !=''){
			$iso3 = strtoupper($iso3);
			if($iso3 == 'KSA'){$iso3 = 'SAU';}
			if($iso3 == 'SAU'){
				$country = 194;
			} else if($iso3 == 'YEM'){
				$country = 248;
			} else if($iso3 == 'ARE'){
				$country = 234;
			} else if($iso3 == 'EGY'){
				$country = 66;
			} else if($iso3 == 'LBN'){
				$country = 122;
			} else if($iso3 == 'JOR'){
				$country = 113;
			} else if($iso3 == 'SYR'){
				$country = 217;
			} else if($iso3 == 'IRQ'){
				$country = 105;
			} else if($iso3 == 'KWT'){
				$country = 118;
			} else if($iso3 == 'OMN'){
				$country = 166;
			} else if($iso3 == 'PSE'){
				$country = 169;
			} else if($iso3 == 'BHR'){
				$country = 18;
			} else if($iso3 == 'QAT'){
				$country = 179;
			} else if($iso3 == 'IRN'){
				$country = 104;
			} else if($iso3 == 'MAR'){
				$country = 149;
			} else if($iso3 == 'TUN'){
				$country = 227;
			} else if($iso3 == 'LBY'){
				$country = 125;
			} else {
				//$country = 248;
				//اذا كان مناطق اخرى
				$country_table = db_prefix() . 'countries';
				$this->db->where('iso3', $iso3);
				$country_row = $this->db->get($table)->row();
				if ($country_row) {
					$country = $country_row->country_id;
				}
			}
		}
		
		$data['name'] = $name;
		$data['company'] = $company;
		$data['phonenumber'] = $phone;
		$data['email'] = $email;
        $data['description'] = nl2br($description);
		$data['country'] = $country;
		$data['city'] = $city;
		$data['state'] = $state;
		$data['address'] = $address;
		$data['website'] = $website;	
		$data['assigned'] = 0;
        $data['dateadded']   = date('Y-m-d H:i:s');
		$data['from_form_id'] = 0;
		$data['status'] = $this->my_api_settings['insert_status_id'];
		$data['source'] = $this->my_api_settings['insert_source_id'];
        $data['addedfrom']   = 1; //get_staff_user_id();		//المستخدم المنفذ للاضافه
		$data['is_public'] = 0;

        $data = hooks()->apply_filters('before_lead_added', $data);

        $this->db->insert(db_prefix() . 'leads', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            echo $insert_id;
			exit;
        }
		
		
		$this->sendApiError('other erorr', 199);
		
        
    }
	
	private function sendApiError($message, $_error_id = 0, $_response_id = 422){
/*
100	نقص في البيانات
101	خطأ في صيغه الاسم
102	الاسم قصير
103	الاسم طويل جداً
105	الاسم مدخل من قبل

111	خطأ في رقم الجوال
112	رقم الجوال قصير
113	رقم الجوال طويل
115	رقم الجوال مدخل من قبل

123	الايميل طويل جداً
133	اسم الشركه طويل جداً
143	رابط الويب طويل جداً

199	خطأ اخر
*/		
		
		$this->output->set_status_header($_response_id);
        echo json_encode([
                    'id' => $_error_id,
                    'message'  => $message
                ]);
		exit;
	}

    private function checkFieldString($_text, $_key = 'str', $remove_any_sign = true){
        $text = trim($_text);
		if($text==''){return '';}
		$text = preg_replace('/\s\s+/', ' ', $text);		
		
		if($_key == 'email'){
            $diacritic = array(' ', 'ِ', 'ُ', 'ٓ', 'ٰ', 'ْ', 'ٌ', 'ٍ', 'ً', 'ّ', 'َ', '/', '\\', ':', '!', '#', '$', '%', '^', '&', '*', '(', ')', ']', '[', '|', '{', '}', '|', '<', '>', ',', '~', '?', '؟'
            , '،', '"', "'");
            $text = str_replace($diacritic, '', $text);
			if(!filter_var($text, FILTER_VALIDATE_EMAIL)) {
				// invalid address
				$text = '';
			}
		} else if($_key == 'url'){
            $diacritic = array(' ', 'ِ', 'ُ', 'ٓ', 'ٰ', 'ْ', 'ٌ', 'ٍ', 'ً', 'ّ', 'َ', '!', '#', '$', '%', '^', '&', '*', '(', ')', ']', '[', '|', '{', '}', '|', '<', '>', ',', '~', '?', '؟'
            , '،', '"', "'");
            $text = str_replace($diacritic, '', $text);
			if (!filter_var($text, FILTER_VALIDATE_URL)) { 
				// not url
			  $text = '';
			}			
		} else {
			
			
			if($_key == 'dec'){
				$diacritic = array('ِ', 'ُ', 'ٓ', 'ٰ', 'ْ', 'ٌ', 'ٍ', 'ً', 'ّ', 'َ', 'ـ', '/', '\\', ':', '!', '@', '#', '$', '%', '^', '&', '*', '-', '_', '(', ')', ']', '[', '|', '{', '}', '|', '<', '>', ',', '~', '?', '؟'
				, '،', '"', "'");
				$text = str_replace($diacritic, '', $text);    
				
			} else if($_key == 'txt'){ //نص طويل
				$diacritic = array('ِ', 'ُ', 'ٓ', 'ٰ', 'ْ', 'ٌ', 'ٍ', 'ً', 'ّ', 'َ', 'ـ', '#', '$', '&'
				, '،', '"', "'");
				$text = str_replace($diacritic, '', $text);    

			} else {
				if($remove_any_sign){
					$diacritic = array('ِ', 'ُ', 'ٓ', 'ٰ', 'ْ', 'ٌ', 'ٍ', 'ً', 'ّ', 'َ', 'ـ', '/', '\\', ':', '!', '.', '@', '#', '$', '%', '^', '&', '*', '-', '_', '(', ')', ']', '[', '|', '{', '}', '|', '<', '>', ',', '~', '?', '؟'
					, '،', '"', "'");
					$text = str_replace($diacritic, '', $text);    
				}
				
			}

			if(($_key == 'int') || ($_key == 'dec')){
				$text = str_replace(' ', '', $text);				
				if(!is_numeric($text)){
					return 0;
				}

			} else if($_key == 'wrd'){
				$text = str_replace(' ', '', $text);				
				if(is_numeric($text)){
					$text = '';
				}
				
			} else {
				if(is_numeric($text)){
					$text = '';
				}				
			}
		}
					
		return trim($text);
    }
	
}
