<?php

defined('BASEPATH') or exit('No direct script access allowed');

class FiniexApi extends ClientsController
{
	
	private $my_api_settings = [
						'api_user_table'=>'api_finiex_users',
						'api_log_table'=>'api_finiex_logs',
						'prefix_id'=>'2',
						'prefix_name'=>'api_',
						'prefix_pass'=>'7sp',
						'prefix_token'=>'d6t',
						];
						
    public function index()
    {
        show_404();
    }
	
/*
Required Tables

CREATE TABLE IF NOT EXISTS `tblapi_finiex_logs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `log_data` text NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `tblapi_finiex_users` (
  `id` int(11) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `desc` varchar(50) DEFAULT NULL COMMENT 'الصفه',
  `login_name` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `token` varchar(255) DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `login_name` (`login_name`),
  KEY `token` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tblapi_finiex_users` (`id`, `name`, `desc`, `login_name`, `password`, `token`, `status`, `created_at`, `updated_at`) VALUES
	(2506, 'API', NULL, 'api_user_1623', '$2a$08$XPScFFEFVUcp2MYi1xN/0evQe0l3EY34TS9jE5t3TqzYyoKH/cjZO', 'd6t6ce2b0a4bc84b9ad5c2d43b978895a7bb20b525082f84ddf1b45faa10e02296e', 1, '2021-10-17 02:47:25', '2021-10-19 18:03:40');

*/

	public function api_login($key){
		//print_r($this->input->post();;
		//echo '<br>';
		//echo $this->input->post('login_name');
		//exit;
        if($this->input->post('key')){				//يتم ايقافهم مؤقتا حتى يتم التعام مع post
            if ($this->input->post('key') == $key) {
				$post_data = $this->input->post();
				$field = 'log_id';
                if (!isset($post_data[$field]) || isset($post_data[$field]) && empty($post_data[$field])) {
					$this->output->set_status_header(422);
					die;
				}
				$api_userid = $post_data[$field];
				
				$field = 'log_name';
                if (!isset($post_data[$field]) || isset($post_data[$field]) && empty($post_data[$field])) {
					$this->output->set_status_header(422);
					die;
				}
				$api_login_name = $post_data[$field];
				
				$field = 'log_pass';
                if (!isset($post_data[$field]) || isset($post_data[$field]) && empty($post_data[$field])) {
					$this->output->set_status_header(422);
					die;
				}
				$api_password = $post_data[$field];

				//$api_userid = "506";
				//$api_login_name = "api_user_1623";
				//$api_password = "e5090024c093405f39f4084aab37dc5b";
				
				//يفحص تسجيل الدخول بشكل صحيح
				if(!$this->checkApiLogin($api_userid, $api_login_name, $api_password)){
					show_404();
					exit;
				}
				$token = $this->apiUpdateToken($api_userid);
				if(!$token){
					show_404();
					exit;					
				}
				echo $token;
				return true;
			}
		}
		
		show_404();
	}
	
	
	
	private function apiUpdateToken($api_userid){
		//return false;
		if(empty($api_userid)){return false;}
		
		$new_token = md5(app_generate_hash()).app_generate_hash();
		
        $table    = $this->my_api_settings['api_user_table'];
        $this->db->where('id', $this->my_api_settings['prefix_id'].$api_userid);
        $this->db->update(db_prefix() . $table, [
            'token' => $this->my_api_settings['prefix_token'].$new_token,
        ]);
        if ($this->db->affected_rows() > 0) {
			return $new_token;
        }
		return false;
	}
	
	private function checkApiLogin($api_userid, $login_name, $password){
        if ((!empty($api_userid)) and (!empty($login_name)) and (!empty($password))) {
			$api_password = $password;
			if(substr($api_password, 0, strlen($this->my_api_settings['prefix_pass'])) != $this->my_api_settings['prefix_pass']){
				return false;
			}
			$api_password = substr($api_password, strlen($this->my_api_settings['prefix_pass']));
			
			
            $table = db_prefix() . $this->my_api_settings['api_user_table'];
            $this->db->where('id', $this->my_api_settings['prefix_id'].$api_userid);
            $this->db->where('login_name', $this->my_api_settings['prefix_name'].$login_name);
            $api_user = $this->db->get($table)->row();
            if ($api_user) {
                // login_name is okey lets check the password now
                if (!app_hasher()->CheckPassword($api_password, $api_user->password)) {
                    hooks()->do_action('failed_login_attempt', [
                        'api_user'            => $api_user,
                    ]);

                    $this->api_insert_log('Failed Api Login Attempt [Login_Name: ' . $login_name . ', IP: ' . $this->input->ip_address() . ']');

                    // Password failed, return
                    return false;
                }
            } else {

                hooks()->do_action('non_existent_user_login_attempt', [
                        'login_name'           => $login_name,
                ]);

                $this->api_insert_log('Non Existing Api User Tried to Login [login_name: ' . $login_name . ', IP: ' . $this->input->ip_address() . ']');

                return false;
            }

            if ($api_user->status != 1) {
                hooks()->do_action('inactive_user_login_attempt', [
                        'user'            => $api_user,
                ]);
                $this->api_insert_log('Inactive Api User Tried to Login [login_name: ' . $login_name . ', IP: ' . $this->input->ip_address() . ']');

                return [
                    'memberinactive' => true,
                ];
            }
			return true;
		}
		return false;
	}

	
	private function checkApiToken($api_userid, $token){
        if ((!empty($api_userid)) and (!empty($token))) {
			//updated_at
            $table = db_prefix() . $this->my_api_settings['api_user_table'];
            $this->db->where('id', $this->my_api_settings['prefix_id'].$api_userid);
            $this->db->where('token', $this->my_api_settings['prefix_token'].$token);
			$this->db->where("updated_at >= '". date('Y-m-d', strtotime('-1 day'))."'");
            $api_user = $this->db->get($table)->row();
            if (!$api_user) {
                $this->api_insert_log('Non Existing Api User Tried to Token [token: ' . $token . ', IP: ' . $this->input->ip_address() . ']');
                return false;
            }
            if ($api_user->status != 1) {
                $this->api_insert_log('Inactive Api User Tried to Token [token: ' . $token . ', IP: ' . $this->input->ip_address() . ']');

                return [
                    'memberinactive' => true,
                ];
            }
			return true;
		}
		return false;
	}
	
	
    public function api_send_data($key)
    {

        if($this->input->post('key')){			
            if ($this->input->post('key') == $key) {
				$post_data = $this->input->post();
				$field = 'log_id';
                if (!isset($post_data[$field]) || isset($post_data[$field]) && empty($post_data[$field])) {
					$this->output->set_status_header(422);
					die;
				}
				$api_userid = $post_data[$field];
				
				
				$field = '_token';
                if (!isset($post_data[$field]) || isset($post_data[$field]) && empty($post_data[$field])) {
					$this->output->set_status_header(422);
					die;
				}
				$api_token = $post_data[$field];

				if(!$this->checkApiToken($api_userid, $api_token)){
					show_404();
					exit;
				}

				
				echo 'goood';
				exit;
            }
        }

		show_404();
    }

}
