<?php

defined('BASEPATH') or exit('No direct script access allowed');

/**
 * ========================================
 * SiteWay Controller للتعامل مع Estimate Payments
 * ========================================
 * هذا الـ Controller يسمح بإنشاء روابط دفع للـ Estimates
 * من داخل الـ Admin Panel
 * ========================================
 */

class Sitesway extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('estimates_model');
        $this->load->model('payment_modes_model');
    }

    /**
     * إنشاء رابط دفع لـ Estimate
     * Route: admin/sitesway/pay_estimate/123
     */
    public function pay_estimate($estimate_id)
    {
        // التحقق من الصلاحيات
        if (!has_permission('estimates', '', 'view')) {
            access_denied('Estimates');
        }

        // جلب العرض
        $estimate = $this->estimates_model->get($estimate_id);
        
        if (!$estimate) {
            set_alert('danger', 'عرض السعر غير موجود');
            redirect(admin_url('estimates'));
        }

        // التحقق من أن العرض له عميل
        if (empty($estimate->clientid)) {
            set_alert('danger', 'لا يمكن إنشاء رابط دفع لعرض سعر بدون عميل');
            redirect(admin_url('estimates/estimate/' . $estimate_id));
        }

        // تحميل الـ Gateway
        $this->load->library('gateways/sitesway_gateway');
        
        // إنشاء رابط الدفع
        $payment_url = $this->sitesway_gateway->createEstimatePaymentLink(
            $estimate_id,
            $estimate->total
        );

        if ($payment_url) {
            // تسجيل النشاط
            log_activity('Created SiteWay payment link for Estimate #' . format_estimate_number($estimate_id));
            
            // إعادة التوجيه لصفحة الدفع
            redirect($payment_url);
        } else {
            set_alert('danger', 'حدث خطأ أثناء إنشاء رابط الدفع. يرجى التحقق من إعدادات SiteWay.');
            redirect(admin_url('estimates/estimate/' . $estimate_id));
        }
    }

    /**
     * الحصول على رابط الدفع كـ JSON (للاستخدام في AJAX)
     * Route: admin/sitesway/get_payment_link/123
     */
    public function get_payment_link($estimate_id)
    {
        // التحقق من الصلاحيات
        if (!has_permission('estimates', '', 'view')) {
            echo json_encode(['success' => false, 'message' => 'Access denied']);
            exit;
        }

        $estimate = $this->estimates_model->get($estimate_id);
        
        if (!$estimate) {
            echo json_encode(['success' => false, 'message' => 'Estimate not found']);
            exit;
        }

        if (empty($estimate->clientid)) {
            echo json_encode(['success' => false, 'message' => 'No client assigned']);
            exit;
        }

        $this->load->library('gateways/sitesway_gateway');
        
        $payment_url = $this->sitesway_gateway->createEstimatePaymentLink(
            $estimate_id,
            $estimate->total
        );

        if ($payment_url) {
            echo json_encode([
                'success' => true,
                'payment_url' => $payment_url,
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Failed to create payment link',
            ]);
        }
    }
}