<?php defined('BASEPATH') or exit('No direct script access allowed');

/**
 * دالة التفقيط الاحترافية
 */
if (!function_exists('formatMoneyArabicFull')) {
    function formatMoneyArabicFull($number) {
        $number = number_format($number, 2, '.', '');
        $parts = explode('.', $number);
        $riyal = (int)$parts[0];
        $halala = (int)$parts[1];

        $ones = [
            '', 'واحد', 'اثنان', 'ثلاثة', 'أربعة', 'خمسة', 'ستة', 'سبعة', 'ثمانية', 'تسعة',
            'عشرة', 'أحد عشر', 'اثنا عشر', 'ثلاثة عشر', 'أربعة عشر', 'خمسة عشر', 
            'ستة عشر', 'سبعة عشر', 'ثمانية عشر', 'تسعة عشر'
        ];

        $tens = [
            '', '', 'عشرون', 'ثلاثون', 'أربعون', 'خمسون', 'ستون', 'سبعون', 'ثمانون', 'تسعون'
        ];

        $hundreds = [
            '', 'مائة', 'مائتان', 'ثلاثمائة', 'أربعمائة', 'خمسمائة', 'ستمائة', 'سبعمائة', 'ثمانمائة', 'تسعمائة'
        ];

        $convertHundreds = function($num) use ($ones, $tens, $hundreds) {
            if ($num == 0) return '';
            $str = '';
            $h = floor($num / 100);
            if ($h > 0) {
                $str = $hundreds[$h];
            }
            $remainder = $num % 100;
            if ($remainder > 0 && $remainder < 20) {
                if ($str != '') $str .= ' و';
                $str .= $ones[$remainder];
            } elseif ($remainder >= 20) {
                $t = floor($remainder / 10);
                $o = $remainder % 10;
                if ($str != '') $str .= ' و';
                if ($o > 0) {
                    $str .= $ones[$o] . ' و' . $tens[$t];
                } else {
                    $str .= $tens[$t];
                }
            }
            return $str;
        };

        $convertNumber = function($num) use ($convertHundreds) {
            if ($num == 0) return 'صفر';
            $result = '';
            
            $billion = floor($num / 1000000000);
            if ($billion > 0) {
                if ($billion == 1) {
                    $result .= 'مليار';
                } elseif ($billion == 2) {
                    $result .= 'ملياران';
                } else {
                    $result .= $convertHundreds($billion) . ' مليار';
                }
                $num %= 1000000000;
            }
            
            $million = floor($num / 1000000);
            if ($million > 0) {
                if ($result != '') $result .= ' و';
                if ($million == 1) {
                    $result .= 'مليون';
                } elseif ($million == 2) {
                    $result .= 'مليونان';
                } else {
                    $result .= $convertHundreds($million) . ' مليون';
                }
                $num %= 1000000;
            }
            
            $thousand = floor($num / 1000);
            if ($thousand > 0) {
                if ($result != '') $result .= ' و';
                if ($thousand == 1) {
                    $result .= 'ألف';
                } elseif ($thousand == 2) {
                    $result .= 'ألفان';
                } else {
                    $result .= $convertHundreds($thousand) . ' ألف';
                }
                $num %= 1000;
            }
            
            if ($num > 0) {
                if ($result != '') $result .= ' و';
                $result .= $convertHundreds($num);
            }
            
            return $result;
        };

        $output = 'فقط ' . $convertNumber($riyal) . ' ريال سعودي';
        if ($halala > 0) {
            $output .= ' و' . $convertNumber($halala) . ' هللة';
        }
        $output .= ' لا غير.';
        
        return $output;
    }
}

if ($invoice->status == Invoices_model::STATUS_DRAFT) { ?>
<div class="alert alert-info">
    <?= _l('invoice_draft_status_info'); ?>
</div>
<?php }
if (isset($invoice->scheduled_email) && $invoice->scheduled_email) { ?>
<div class="alert alert-warning">
    <?= e(_l('invoice_will_be_sent_at', _dt($invoice->scheduled_email->scheduled_at))); ?>
    <?php if (staff_can('edit', 'invoices') || $invoice->addedfrom == get_staff_user_id()) { ?>
    <a href="#"
        onclick="edit_invoice_scheduled_email(<?= $invoice->scheduled_email->id; ?>); return false;">
        <?= _l('edit'); ?>
    </a>
    <?php } ?>
</div>
<?php } ?>

<div id="invoice-preview" style="direction: rtl; padding: 20px; background: #fff;">
    
    <!-- الهيدر الاحترافي المتظبط -->
    <div class="row" style="margin-bottom: 30px; border-bottom: 3px solid #2563eb; padding-bottom: 20px;">
        <div class="col-md-4 text-left">
            <?php 
            $company_logo = get_option('company_logo');
            if(!empty($company_logo)) { ?>
                <img src="<?= base_url('uploads/company/' . $company_logo); ?>" 
                     style="max-width: 180px; max-height: 100px;" 
                     alt="<?= get_option('invoice_company_name'); ?>">
            <?php } else { ?>
                <img src="https://via.placeholder.com/180x80?text=LOGO" 
                     style="max-width: 180px; max-height: 100px;">
            <?php } ?>
        </div>
        <div class="col-md-8 text-right">
            <h3 style="color: #2563eb; font-weight: bold; margin-top: 0;">
                <?= get_option('companyname') ?: get_option('invoice_company_name') ?: 'اسم المنشأة'; ?>
            </h3>
            <p style="margin-bottom: 2px;">
                <strong>العنوان:</strong> <?= get_option('company_address') ?: get_option('address') ?: 'عنوان المنشأة'; ?>
            </p>
            <p style="margin-bottom: 2px;">
                <strong>السجل التجاري:</strong> <?= get_option('company_id_number') ?: get_option('company_registration_number') ?: 'رقم السجل'; ?> 
                | <strong>الرقم الضريبي:</strong> <?= get_option('company_vat_number') ?: get_option('companyvat') ?: 'الرقم الضريبي'; ?>
            </p>
            <p style="margin-bottom: 2px;">
                <strong>رقم التواصل:</strong> <?= get_option('company_phonenumber') ?: get_option('phonenumber') ?: 'رقم الهاتف'; ?>
            </p>
        </div>
    </div>

    <div class="text-center" style="margin-bottom: 30px;">
        <h2 style="font-weight: bold; text-decoration: underline; color: #333;">فاتورة</h2>
    </div>

    <!-- بيانات الفاتورة والعميل -->
    <div class="row" style="margin-bottom: 20px;">
        <div class="col-md-6 text-left">
            <p><strong>رقم الفاتورة:</strong> <?= e(format_invoice_number($invoice->id)); ?></p>
            <p><strong>التاريخ:</strong> <?= e(_d($invoice->date)); ?> 
            <?php if (!empty($invoice->duedate)) { ?>
                | <strong>تاريخ الاستحقاق:</strong> <?= e(_d($invoice->duedate)); ?>
            <?php } ?>
            </p>
            <?php if ($invoice->sale_agent && get_option('show_sale_agent_on_invoices') == 1) { ?>
            <p><strong>مندوب المبيعات:</strong> <?= e(get_staff_full_name($invoice->sale_agent)); ?></p>
            <?php } ?>
            <?php if ($invoice->project_id && get_option('show_project_on_invoice') == 1) { ?>
            <p><strong>المشروع:</strong> <?= e(get_project_name_by_id($invoice->project_id)); ?></p>
            <?php } ?>
        </div>
        <div class="col-md-6 text-right">
            <div style="background: #f0f7ff; padding: 15px; border: 2px solid #2563eb; border-radius: 5px;">
                <p style="font-size: 1.1em; color: #2563eb; margin-bottom: 10px;"><strong>بيانات العميل</strong></p>
                <div style="color: #333;">
                    <?= format_customer_info($invoice, 'invoice', 'billing', true); ?>
                </div>
                <?php if ($invoice->include_shipping == 1 && $invoice->show_shipping_on_invoice == 1) { ?>
                <hr style="margin: 10px 0;">
                <p style="font-weight: bold; margin-bottom: 5px;">عنوان الشحن:</p>
                <div style="color: #555;">
                    <?= format_customer_info($invoice, 'invoice', 'shipping'); ?>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>

    <!-- جدول الأصناف الاحترافي -->
    <div class="table-responsive">
        <?php $items = get_items_table_data($invoice, 'invoice', 'html', true); ?>
        <?= $items->table(); ?>
    </div>

    <!-- الإجماليات والتفقيط -->
    <div class="row" style="margin-top: 20px;">
        <div class="col-md-7">
            <div style="padding: 15px; border: 2px dashed #2563eb; background: #f0f7ff; border-radius: 5px;">
                <p style="margin-bottom: 5px; font-weight: bold; color: #2563eb;">المبلغ كتابةً:</p>
                <p style="font-size: 1.2em; font-weight: bold;"><?= formatMoneyArabicFull($invoice->total); ?></p>
            </div>
        </div>
        <div class="col-md-5">
            <table class="table text-right">
                <tr>
                    <td style="font-weight: bold;">الإجمالي (قبل الضريبة)</td>
                    <td><?= e(app_format_money($invoice->subtotal, $invoice->currency_name)); ?></td>
                </tr>
                <?php if (is_sale_discount_applied($invoice)) { ?>
                <tr>
                    <td style="font-weight: bold;">الخصم
                        <?php if (is_sale_discount($invoice, 'percent')) { ?>
                        (<?= e(app_format_number($invoice->discount_percent, true)); ?>%)
                        <?php } ?>
                    </td>
                    <td><?= e('-' . app_format_money($invoice->discount_total, $invoice->currency_name)); ?></td>
                </tr>
                <?php } ?>
                <tr>
                    <td style="font-weight: bold;">الإجمالي الخاضع للضريبة</td>
                    <td><?= e(app_format_money($invoice->subtotal - $invoice->discount_total, $invoice->currency_name)); ?></td>
                </tr>
                <?php foreach ($items->taxes() as $tax) { ?>
                <tr>
                    <td style="font-weight: bold;"><?= e($tax['taxname']); ?> (<?= e(app_format_number($tax['taxrate'])); ?>%)</td>
                    <td><?= e(app_format_money($tax['total_tax'], $invoice->currency_name)); ?></td>
                </tr>
                <?php } ?>
                <?php if ((int) $invoice->adjustment != 0) { ?>
                <tr>
                    <td style="font-weight: bold;">التعديل</td>
                    <td><?= e(app_format_money($invoice->adjustment, $invoice->currency_name)); ?></td>
                </tr>
                <?php } ?>
                <tr style="background: #2563eb; color: #fff; font-size: 1.3em; font-weight: bold;">
                    <td>إجمالي المبلغ المستحق</td>
                    <td><?= e(app_format_money($invoice->total, $invoice->currency_name)); ?></td>
                </tr>
                <?php if (count($invoice->payments) > 0 && get_option('show_total_paid_on_invoice') == 1) { ?>
                <tr style="background: #d4edda;">
                    <td style="font-weight: bold; color: #155724;">المبلغ المدفوع</td>
                    <td style="color: #155724;"><?= e('-' . app_format_money(sum_from_table(db_prefix() . 'invoicepaymentrecords', ['field' => 'amount', 'where' => ['invoiceid' => $invoice->id]]), $invoice->currency_name)); ?></td>
                </tr>
                <?php } ?>
                <?php if (get_option('show_credits_applied_on_invoice') == 1 && $credits_applied = total_credits_applied_to_invoice($invoice->id)) { ?>
                <tr>
                    <td style="font-weight: bold;">الائتمانات المطبقة</td>
                    <td><?= e('-' . app_format_money($credits_applied, $invoice->currency_name)); ?></td>
                </tr>
                <?php } ?>
                <?php if (get_option('show_amount_due_on_invoice') == 1 && $invoice->status != Invoices_model::STATUS_CANCELLED) { ?>
                <tr style="background: <?= $invoice->total_left_to_pay > 0 ? '#f8d7da' : '#d4edda'; ?>;">
                    <td style="font-weight: bold; color: <?= $invoice->total_left_to_pay > 0 ? '#721c24' : '#155724'; ?>;">المبلغ المتبقي</td>
                    <td style="font-weight: bold; color: <?= $invoice->total_left_to_pay > 0 ? '#721c24' : '#155724'; ?>;"><?= e(app_format_money($invoice->total_left_to_pay, $invoice->currency_name)); ?></td>
                </tr>
                <?php } ?>
            </table>
        </div>
    </div>

    <?php if (count($invoice->attachments) > 0) { ?>
    <div class="clearfix"></div>
    <hr />
    <p class="tw-text-neutral-700 tw-font-medium">
        <?= _l('invoice_files'); ?>
    </p>
    <?php foreach ($invoice->attachments as $attachment) {
        $attachment_url = site_url('download/file/sales_attachment/' . $attachment['attachment_key']);
        if (!empty($attachment['external'])) {
            $attachment_url = $attachment['external_link'];
        } ?>
    <div class="mbot15 row inline-block full-width"
        data-attachment-id="<?= e($attachment['id']); ?>">
        <div class="col-md-8">
            <a href="<?= e($attachment_url); ?>"
                target="_blank"><?= e($attachment['file_name']); ?></a>
            <br />
            <small class="text-muted">
                <?= e($attachment['filetype']); ?></small>
        </div>
        <div class="col-md-4 text-right tw-space-x-2">
            <?php if ($attachment['visible_to_customer'] == 0) {
                $icon    = 'fa-toggle-off';
                $tooltip = _l('show_to_customer');
            } else {
                $icon    = 'fa-toggle-on';
                $tooltip = _l('hide_from_customer');
            } ?>
            <a href="#" data-toggle="tooltip" class="text-muted"
                onclick="toggle_file_visibility(<?= e($attachment['id']); ?>,<?= e($invoice->id); ?>,this); return false;"
                data-title="<?= e($tooltip); ?>">
                <i class="fa <?= e($icon); ?> fa-lg"
                    aria-hidden="true"></i>
            </a>
            <?php if ($attachment['staffid'] == get_staff_user_id() || is_admin()) { ?>
            <a href="#" class="text-muted"
                onclick="delete_invoice_attachment(<?= e($attachment['id']); ?>); return false;">
                <i class="fa-regular fa-trash-can"></i>
            </a>
            <?php } ?>
        </div>
    </div>
    <?php } ?>
    <?php } ?>

    <?php if ($invoice->clientnote != '') { ?>
    <div class="col-md-12 mtop15 text-right">
        <p class="tw-text-neutral-700 tw-font-medium"><?= _l('invoice_note'); ?></p>
        <div class="tw-text-neutral-500 tw-leading-relaxed">
            <?= process_text_content_for_display($invoice->clientnote); ?>
        </div>
    </div>
    <?php } ?>
    <?php if ($invoice->terms != '') { ?>
    <div class="col-md-12 mtop15 text-right">
        <p class="tw-text-neutral-700 tw-font-medium"><?= _l('terms_and_conditions'); ?></p>
        <div class="tw-text-neutral-500 tw-leading-relaxed">
            <?= process_text_content_for_display($invoice->terms); ?>
        </div>
    </div>
    <?php } ?>
</div>