<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * دالة التفقيط الاحترافية للـ PDF
 */
if (!function_exists('formatMoneyArabicFullPDF')) {
    function formatMoneyArabicFullPDF($number) {
        $number = number_format($number, 2, '.', '');
        $parts = explode('.', $number);
        $riyal = (int)$parts[0];
        $halala = (int)$parts[1];

        $ones = [
            '', 'واحد', 'اثنان', 'ثلاثة', 'أربعة', 'خمسة', 'ستة', 'سبعة', 'ثمانية', 'تسعة',
            'عشرة', 'أحد عشر', 'اثنا عشر', 'ثلاثة عشر', 'أربعة عشر', 'خمسة عشر', 
            'ستة عشر', 'سبعة عشر', 'ثمانية عشر', 'تسعة عشر'
        ];

        $tens = [
            '', '', 'عشرون', 'ثلاثون', 'أربعون', 'خمسون', 'ستون', 'سبعون', 'ثمانون', 'تسعون'
        ];

        $hundreds = [
            '', 'مائة', 'مائتان', 'ثلاثمائة', 'أربعمائة', 'خمسمائة', 'ستمائة', 'سبعمائة', 'ثمانمائة', 'تسعمائة'
        ];

        $convertHundreds = function($num) use ($ones, $tens, $hundreds) {
            if ($num == 0) return '';
            $str = '';
            $h = floor($num / 100);
            if ($h > 0) {
                $str = $hundreds[$h];
            }
            $remainder = $num % 100;
            if ($remainder > 0 && $remainder < 20) {
                if ($str != '') $str .= ' و';
                $str .= $ones[$remainder];
            } elseif ($remainder >= 20) {
                $t = floor($remainder / 10);
                $o = $remainder % 10;
                if ($str != '') $str .= ' و';
                if ($o > 0) {
                    $str .= $ones[$o] . ' و' . $tens[$t];
                } else {
                    $str .= $tens[$t];
                }
            }
            return $str;
        };

        $convertNumber = function($num) use ($convertHundreds) {
            if ($num == 0) return 'صفر';
            $result = '';
            
            $billion = floor($num / 1000000000);
            if ($billion > 0) {
                if ($billion == 1) {
                    $result .= 'مليار';
                } elseif ($billion == 2) {
                    $result .= 'ملياران';
                } else {
                    $result .= $convertHundreds($billion) . ' مليار';
                }
                $num %= 1000000000;
            }
            
            $million = floor($num / 1000000);
            if ($million > 0) {
                if ($result != '') $result .= ' و';
                if ($million == 1) {
                    $result .= 'مليون';
                } elseif ($million == 2) {
                    $result .= 'مليونان';
                } else {
                    $result .= $convertHundreds($million) . ' مليون';
                }
                $num %= 1000000;
            }
            
            $thousand = floor($num / 1000);
            if ($thousand > 0) {
                if ($result != '') $result .= ' و';
                if ($thousand == 1) {
                    $result .= 'ألف';
                } elseif ($thousand == 2) {
                    $result .= 'ألفان';
                } else {
                    $result .= $convertHundreds($thousand) . ' ألف';
                }
                $num %= 1000;
            }
            
            if ($num > 0) {
                if ($result != '') $result .= ' و';
                $result .= $convertHundreds($num);
            }
            
            return $result;
        };

        $output = 'فقط ' . $convertNumber($riyal) . ' ريال سعودي';
        if ($halala > 0) {
            $output .= ' و' . $convertNumber($halala) . ' هللة';
        }
        $output .= ' لا غير.';
        
        return $output;
    }
}

$dimensions = $pdf->getPageDimensions();

// الهيدر الاحترافي
$pdf->SetFont($font_name, 'B', 16);

// بيانات الشركة
$company_name = get_option('companyname') ?: get_option('invoice_company_name') ?: 'اسم المنشأة';
$company_address = get_option('company_address') ?: get_option('address') ?: 'عنوان المنشأة';
$company_vat = get_option('company_vat_number') ?: get_option('companyvat') ?: 'الرقم الضريبي';
$company_phone = get_option('company_phonenumber') ?: get_option('phonenumber') ?: 'رقم الهاتف';
$company_id = get_option('company_id_number') ?: get_option('company_registration_number') ?: 'رقم السجل';

// اللوجو
$logo_path = get_option('company_logo');
if (!empty($logo_path)) {
    $logo_url = FCPATH . 'uploads/company/' . $logo_path;
    if (file_exists($logo_url)) {
        $pdf->Image($logo_url, 15, 10, 40, 0, '', '', '', false, 300, '', false, false, 0);
    }
}

// اسم المنشأة والبيانات على اليمين
$pdf->SetXY($dimensions['wk'] - 120, 15);
$pdf->SetFont($font_name, 'B', 14);
$pdf->SetTextColor(37, 99, 235);
$pdf->Cell(100, 8, $company_name, 0, 1, 'R');

$pdf->SetFont($font_name, '', 10);
$pdf->SetTextColor(0, 0, 0);
$pdf->SetX($dimensions['wk'] - 120);
$pdf->Cell(100, 6, 'العنوان: ' . $company_address, 0, 1, 'R');
$pdf->SetX($dimensions['wk'] - 120);
$pdf->Cell(100, 6, 'السجل التجاري: ' . $company_id, 0, 1, 'R');
$pdf->SetX($dimensions['wk'] - 120);
$pdf->Cell(100, 6, 'الرقم الضريبي: ' . $company_vat, 0, 1, 'R');
$pdf->SetX($dimensions['wk'] - 120);
$pdf->Cell(100, 6, 'رقم التواصل: ' . $company_phone, 0, 1, 'R');

$pdf->Ln(10);

// عنوان "عرض سعر"
$pdf->SetFont($font_name, 'B', 18);
$pdf->Cell(0, 10, 'عرض سعر', 0, 1, 'C');
$pdf->Ln(5);

// بيانات العرض والعميل
$pdf->SetFont($font_name, 'B', 10);

// صندوق معلومات العرض (على اليمين)
$y_position = $pdf->GetY();
$pdf->SetFillColor(249, 249, 249);
$pdf->SetXY(15, $y_position);
$pdf->Cell(85, 6, '', 0, 1, 'R', false);

$pdf->SetXY(15, $y_position);
$pdf->SetFont($font_name, 'B', 10);
$pdf->Cell(85, 6, 'رقم عرض السعر: ' . $estimate_number, 0, 1, 'R', false);

$pdf->SetX(15);
$pdf->SetFont($font_name, '', 9);
$pdf->Cell(85, 5, 'التاريخ: ' . _d($estimate->date), 0, 1, 'R', false);

$pdf->SetX(15);
$pdf->Cell(85, 5, 'الصلاحية: ' . _d($estimate->expirydate), 0, 1, 'R', false);

if ($estimate->sale_agent) {
    $pdf->SetX(15);
    $pdf->Cell(85, 5, 'مندوب المبيعات: ' . get_staff_full_name($estimate->sale_agent), 0, 1, 'R', false);
}

// صندوق معلومات العميل (على اليسار)
$pdf->SetY($y_position);
$pdf->SetFillColor(240, 247, 255);
$pdf->SetXY($dimensions['wk'] - 100, $y_position);
$pdf->SetFont($font_name, 'B', 10);
$pdf->SetTextColor(37, 99, 235);
$pdf->Cell(85, 6, 'بيانات العميل', 1, 1, 'R', true);

$pdf->SetX($dimensions['wk'] - 100);
$pdf->SetFont($font_name, '', 9);
$pdf->SetTextColor(0, 0, 0);
$pdf->SetFillColor(255, 255, 255);
$client_name = $estimate->client ? $estimate->client->company : '';
$pdf->Cell(85, 5, 'السيد/ة: ' . $client_name, 1, 1, 'R', true);

$pdf->SetX($dimensions['wk'] - 100);
$client_address = format_customer_info($estimate, 'estimate', 'billing', false);
$pdf->MultiCell(85, 5, 'العنوان: ' . strip_tags($client_address), 1, 'R', true);

$pdf->Ln(4);

$pdf->writeHTML('<style>
    table { direction: rtl; border-collapse: collapse; width: 100%; }
    th, td { border-bottom: 1px solid #ddd; padding: 8px; }
    /* تخلي العناوين في النص */
    th { text-align: center; background-color: #3d4a5c; color: #fff; }
    /* تخلي أول خانة (الرقم) والعنصر يمين */
    td:first-child, td:nth-child(2) { text-align: right; }
    /* تخلي آخر خانة (المبلغ) شمال */
    td:last-child { text-align: left; }
</style>', true, false, false, false, '');

// جدول الأصناف
$items = get_items_table_data($estimate, 'estimate', 'pdf');
$tblhtml = $items->table();
$pdf->writeHTML($tblhtml, true, false, false, false, '');

$pdf->Ln(8);

// جدول الإجماليات - تعديل ليكون أقصى اليسار مع عكس ترتيب الرقم والنص
$tbltotal = '<table cellpadding="6" style="font-size:' . ($font_size + 2) . 'px; width: 100%;">';

// الإجمالي (قبل الضريبة)
$tbltotal .= '<tr>
    <td width="60%"></td> 
    <td align="left" width="15%" style="border-bottom: 1px solid #eee;">' . app_format_money($estimate->subtotal, $estimate->currency_name) . '</td>
    <td align="right" width="25%" style="border-bottom: 1px solid #eee;"><strong>الإجمالي (قبل الضريبة)</strong></td>
</tr>';

// مجموع الخصومات
if (is_sale_discount_applied($estimate)) {
    $tbltotal .= '<tr>
        <td width="60%"></td>
        <td align="left" width="15%" style="border-bottom: 1px solid #eee;">' . app_format_money($estimate->discount_total, $estimate->currency_name) . '</td>
        <td align="right" width="25%" style="border-bottom: 1px solid #eee;"><strong>مجموع الخصومات</strong></td>
    </tr>';
}

// الإجمالي الخاضع للضريبة
$tbltotal .= '<tr>
    <td width="60%"></td>
    <td align="left" width="15%" style="border-bottom: 1px solid #eee;">' . app_format_money($estimate->subtotal - $estimate->discount_total, $estimate->currency_name) . '</td>
    <td align="right" width="25%" style="border-bottom: 1px solid #eee;"><strong>الإجمالي الخاضع للضريبة</strong></td>
</tr>';

// الضريبة
foreach ($items->taxes() as $tax) {
    $tbltotal .= '<tr>
        <td width="60%"></td>
        <td align="left" width="15%" style="border-bottom: 1px solid #eee;">' . app_format_money($tax['total_tax'], $estimate->currency_name) . '</td>
        <td align="right" width="25%" style="border-bottom: 1px solid #eee;"><strong>' . $tax['taxname'] . ' (' . app_format_number($tax['taxrate']) . '%)</strong></td>
    </tr>';
}

// إجمالي المبلغ المستحق (السطر الأزرق)
$tbltotal .= '<tr>
    <td width="60%"></td>
    <td align="left" width="15%" style="background-color:#2563eb; color:#fff;"><strong>' . app_format_money($estimate->total, $estimate->currency_name) . '</strong></td>
    <td align="right" width="25%" style="background-color:#2563eb; color:#fff;"><strong>إجمالي المبلغ المستحق</strong></td>
</tr>';

$tbltotal .= '</table>';

$pdf->writeHTML($tbltotal, true, false, false, false, '');


// التفقيط
$pdf->Ln(6);
$pdf->SetFont($font_name, 'B', 11);
$pdf->SetFillColor(240, 247, 255);
$pdf->SetTextColor(37, 99, 235);
$pdf->Cell(0, 8, 'المبلغ كتابةً:', 1, 1, 'R', true);
$pdf->SetFont($font_name, '', 10);
$pdf->SetTextColor(0, 0, 0);
$pdf->MultiCell(0, 8, formatMoneyArabicFullPDF($estimate->total), 1, 'R', false);

$pdf->Ln(4);

// ملاحظات العميل
if (!empty($estimate->clientnote)) {
    $pdf->SetFont($font_name, 'B', $font_size);
    $pdf->Cell(0, 0, _l('estimate_note'), 0, 1, 'R', 0, '', 0);
    $pdf->SetFont($font_name, '', $font_size);
    $pdf->Ln(2);
    $pdf->writeHTMLCell('', '', '', '', $estimate->clientnote, 0, 1, false, true, 'R', true);
}

// الشروط والأحكام
if (!empty($estimate->terms)) {
    $pdf->Ln(4);
    $pdf->SetFont($font_name, 'B', $font_size);
    $pdf->Cell(0, 0, _l('terms_and_conditions') . ':', 0, 1, 'R', 0, '', 0);
    $pdf->SetFont($font_name, '', $font_size);
    $pdf->Ln(2);
    $pdf->writeHTMLCell('', '', '', '', $estimate->terms, 0, 1, false, true, 'R', true);
}