<?php defined('BASEPATH') or exit('No direct script access allowed'); 

/**
 * دالة التفقيط للعميل
 */
if (!function_exists('formatMoneyArabicFull')) {
    function formatMoneyArabicFull($number) {
        $number = number_format($number, 2, '.', '');
        $parts = explode('.', $number);
        $riyal = (int)$parts[0];
        $halala = (int)$parts[1];

        $ones = [
            '', 'واحد', 'اثنان', 'ثلاثة', 'أربعة', 'خمسة', 'ستة', 'سبعة', 'ثمانية', 'تسعة',
            'عشرة', 'أحد عشر', 'اثنا عشر', 'ثلاثة عشر', 'أربعة عشر', 'خمسة عشر', 
            'ستة عشر', 'سبعة عشر', 'ثمانية عشر', 'تسعة عشر'
        ];

        $tens = [
            '', '', 'عشرون', 'ثلاثون', 'أربعون', 'خمسون', 'ستون', 'سبعون', 'ثمانون', 'تسعون'
        ];

        $hundreds = [
            '', 'مائة', 'مائتان', 'ثلاثمائة', 'أربعمائة', 'خمسمائة', 'ستمائة', 'سبعمائة', 'ثمانمائة', 'تسعمائة'
        ];

        $convertHundreds = function($num) use ($ones, $tens, $hundreds) {
            if ($num == 0) return '';
            $str = '';
            $h = floor($num / 100);
            if ($h > 0) {
                $str = $hundreds[$h];
            }
            $remainder = $num % 100;
            if ($remainder > 0 && $remainder < 20) {
                if ($str != '') $str .= ' و';
                $str .= $ones[$remainder];
            } elseif ($remainder >= 20) {
                $t = floor($remainder / 10);
                $o = $remainder % 10;
                if ($str != '') $str .= ' و';
                if ($o > 0) {
                    $str .= $ones[$o] . ' و' . $tens[$t];
                } else {
                    $str .= $tens[$t];
                }
            }
            return $str;
        };

        $convertNumber = function($num) use ($convertHundreds) {
            if ($num == 0) return 'صفر';
            $result = '';
            
            $billion = floor($num / 1000000000);
            if ($billion > 0) {
                if ($billion == 1) {
                    $result .= 'مليار';
                } elseif ($billion == 2) {
                    $result .= 'ملياران';
                } else {
                    $result .= $convertHundreds($billion) . ' مليار';
                }
                $num %= 1000000000;
            }
            
            $million = floor($num / 1000000);
            if ($million > 0) {
                if ($result != '') $result .= ' و';
                if ($million == 1) {
                    $result .= 'مليون';
                } elseif ($million == 2) {
                    $result .= 'مليونان';
                } else {
                    $result .= $convertHundreds($million) . ' مليون';
                }
                $num %= 1000000;
            }
            
            $thousand = floor($num / 1000);
            if ($thousand > 0) {
                if ($result != '') $result .= ' و';
                if ($thousand == 1) {
                    $result .= 'ألف';
                } elseif ($thousand == 2) {
                    $result .= 'ألفان';
                } else {
                    $result .= $convertHundreds($thousand) . ' ألف';
                }
                $num %= 1000;
            }
            
            if ($num > 0) {
                if ($result != '') $result .= ' و';
                $result .= $convertHundreds($num);
            }
            
            return $result;
        };

        $output = 'فقط ' . $convertNumber($riyal) . ' ريال سعودي';
        if ($halala > 0) {
            $output .= ' و' . $convertNumber($halala) . ' هللة';
        }
        $output .= ' لا غير.';
        
        return $output;
    }
}
?>

<div class="mtop15 preview-top-wrapper">
    <div class="row">
        <div class="col-md-3">
            <div class="mbot30">
                <div class="invoice-html-logo">
                    <?= get_dark_company_logo(); ?>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
    </div>
    <div class="top" data-sticky data-sticky-class="preview-sticky-header">
        <div class="container preview-sticky-container">
            <div class="sm:tw-flex tw-justify-between -tw-mx-4">
                <div class="sm:tw-self-end">
                    <h3 class="bold tw-my-0 invoice-html-number">
                        <span class="sticky-visible hide tw-mb-2">
                            <?= e(format_invoice_number($invoice->id)); ?>
                        </span>
                    </h3>
                    <span class="invoice-html-status">
                        <?= format_invoice_status($invoice->status, '', true); ?>
                    </span>
                </div>
                <div class="tw-flex tw-items-end tw-space-x-2 tw-mt-3 sm:tw-mt-0">
                    <?php if (is_client_logged_in() && has_contact_permission('invoices')) { ?>
                    <a href="<?= site_url('clients/invoices/'); ?>"
                        class="btn btn-default action-button go-to-portal">
                        <?= _l('client_go_to_dashboard'); ?>
                    </a>
                    <?php } ?>
                    <?= form_open($this->uri->uri_string()); ?>
                    <button type="submit" name="invoicepdf" value="invoicepdf" class="btn btn-default action-button">
                        <i class='fa-regular fa-file-pdf'></i>
                        <?= _l('clients_invoice_html_btn_download'); ?>
                    </button>
                    <?= form_close(); ?>

                    <a href="#" class="btn btn-success action-button invoice-html-pay-now-top hide sticky-hidden
                  <?php if (($invoice->status != Invoices_model::STATUS_PAID && $invoice->status != Invoices_model::STATUS_CANCELLED
                     && $invoice->total > 0) && found_invoice_mode($payment_modes, $invoice->id, false)) {
                      echo ' pay-now-top';
                  } ?>">
                        <?= _l('invoice_html_online_payment_button_text'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="clearfix"></div>

<div class="panel_s tw-mt-6">
    <div class="panel-body">
        <?php if (is_invoice_overdue($invoice)) { ?>
        <div class="col-md-10 col-md-offset-1 tw-mb-5">
            <div class="alert alert-danger text-center">
                <p class="tw-font-medium">
                    <?= e(_l('overdue_by_days', get_total_days_overdue($invoice->duedate))); ?>
                </p>
            </div>
        </div>
        <?php } ?>
        <div class="col-md-10 col-md-offset-1">
            
            <!-- التصميم الاحترافي -->
            <div style="direction: rtl; padding: 20px; background: #fff;">
                
                <!-- الهيدر -->
                <div class="row" style="margin-bottom: 30px; border-bottom: 3px solid #2563eb; padding-bottom: 20px;">
                    <div class="col-md-4 text-left">
                        <?php 
                        $company_logo = get_option('company_logo');
                        if(!empty($company_logo)) { ?>
                            <img src="<?= base_url('uploads/company/' . $company_logo); ?>" 
                                 style="max-width: 180px; max-height: 100px;" 
                                 alt="<?= get_option('invoice_company_name'); ?>">
                        <?php } else { ?>
                            <?= get_dark_company_logo(); ?>
                        <?php } ?>
                    </div>
                    <div class="col-md-8 text-right">
                        <h3 style="color: #2563eb; font-weight: bold; margin-top: 0;">
                            <?= get_option('companyname') ?: get_option('invoice_company_name') ?: 'اسم المنشأة'; ?>
                        </h3>
                        <p style="margin-bottom: 2px;">
                            <strong>العنوان:</strong> <?= get_option('company_address') ?: get_option('address') ?: 'عنوان المنشأة'; ?>
                        </p>
                        <p style="margin-bottom: 2px;">
                            <strong>الرقم الضريبي:</strong> <?= get_option('company_vat_number') ?: get_option('companyvat') ?: 'الرقم الضريبي'; ?>
                        </p>
                        <p style="margin-bottom: 2px;">
                            <strong>رقم التواصل:</strong> <?= get_option('company_phonenumber') ?: get_option('phonenumber') ?: 'رقم الهاتف'; ?>
                        </p>
                    </div>
                </div>

                <div class="text-center" style="margin-bottom: 30px;">
                    <h2 style="font-weight: bold; text-decoration: underline; color: #333;">فاتورة</h2>
                </div>

                <!-- بيانات الفاتورة والعميل -->
                <div class="row" style="margin-bottom: 20px;">
                    <div class="col-md-6 text-left">
                        <p><strong>رقم الفاتورة:</strong> <?= e(format_invoice_number($invoice->id)); ?></p>
                        <p><strong>التاريخ:</strong> <?= e(_d($invoice->date)); ?> 
                        <?php if (!empty($invoice->duedate)) { ?>
                            | <strong>تاريخ الاستحقاق:</strong> <?= e(_d($invoice->duedate)); ?>
                        <?php } ?>
                        </p>
                        <?php if ($invoice->sale_agent && get_option('show_sale_agent_on_invoices') == 1) { ?>
                        <p><strong>مندوب المبيعات:</strong> <?= e(get_staff_full_name($invoice->sale_agent)); ?></p>
                        <?php } ?>
                    </div>
                    <div class="col-md-6 text-right">
                        <div style="background: #f0f7ff; padding: 15px; border: 2px solid #2563eb; border-radius: 5px;">
                            <p style="font-size: 1.1em; color: #2563eb; margin-bottom: 10px;"><strong>بيانات العميل</strong></p>
                            <div style="color: #333;">
                                <?= format_customer_info($invoice, 'invoice', 'billing', true); ?>
                            </div>
                            <?php if ($invoice->include_shipping == 1 && $invoice->show_shipping_on_invoice == 1) { ?>
                            <hr style="margin: 10px 0;">
                            <p style="font-weight: bold; margin-bottom: 5px;">عنوان الشحن:</p>
                            <div style="color: #555;">
                                <?= format_customer_info($invoice, 'invoice', 'shipping'); ?>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>

                <!-- جدول الأصناف -->
                <div class="table-responsive">
                    <?php $items = get_items_table_data($invoice, 'invoice'); ?>
                    <?= $items->table(); ?>
                </div>

                <!-- الإجماليات والتفقيط -->
                <div class="row" style="margin-top: 20px;">
                    <div class="col-md-7">
                        <div style="padding: 15px; border: 2px dashed #2563eb; background: #f0f7ff; border-radius: 5px;">
                            <p style="margin-bottom: 5px; font-weight: bold; color: #2563eb;">المبلغ كتابةً:</p>
                            <p style="font-size: 1.2em; font-weight: bold;"><?= formatMoneyArabicFull($invoice->total); ?></p>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <table class="table text-right">
                            <tr>
                                <td style="font-weight: bold;">الإجمالي (قبل الضريبة)</td>
                                <td><?= e(app_format_money($invoice->subtotal, $invoice->currency_name)); ?></td>
                            </tr>
                            <?php if (is_sale_discount_applied($invoice)) { ?>
                            <tr>
                                <td style="font-weight: bold;">الخصم
                                    <?php if (is_sale_discount($invoice, 'percent')) { ?>
                                    (<?= e(app_format_number($invoice->discount_percent, true)); ?>%)
                                    <?php } ?>
                                </td>
                                <td><?= e('-' . app_format_money($invoice->discount_total, $invoice->currency_name)); ?></td>
                            </tr>
                            <?php } ?>
                            <?php foreach ($items->taxes() as $tax) { ?>
                            <tr>
                                <td style="font-weight: bold;"><?= e($tax['taxname']); ?> (<?= e(app_format_number($tax['taxrate'])); ?>%)</td>
                                <td><?= e(app_format_money($tax['total_tax'], $invoice->currency_name)); ?></td>
                            </tr>
                            <?php } ?>
                            <?php if ((int) $invoice->adjustment != 0) { ?>
                            <tr>
                                <td style="font-weight: bold;">التعديل</td>
                                <td><?= e(app_format_money($invoice->adjustment, $invoice->currency_name)); ?></td>
                            </tr>
                            <?php } ?>
                            <tr style="background: #2563eb; color: #fff; font-size: 1.3em; font-weight: bold;">
                                <td>إجمالي المبلغ المستحق</td>
                                <td><?= e(app_format_money($invoice->total, $invoice->currency_name)); ?></td>
                            </tr>
                            <?php if (count($invoice->payments) > 0 && get_option('show_total_paid_on_invoice') == 1) { ?>
                            <tr style="background: #d4edda;">
                                <td style="font-weight: bold; color: #155724;">المبلغ المدفوع</td>
                                <td style="color: #155724;"><?= e('-' . app_format_money(sum_from_table(db_prefix() . 'invoicepaymentrecords', ['field' => 'amount', 'where' => ['invoiceid' => $invoice->id]]), $invoice->currency_name)); ?></td>
                            </tr>
                            <?php } ?>
                            <?php if (get_option('show_credits_applied_on_invoice') == 1 && $credits_applied = total_credits_applied_to_invoice($invoice->id)) { ?>
                            <tr>
                                <td style="font-weight: bold;">الائتمانات المطبقة</td>
                                <td><?= e('-' . app_format_money($credits_applied, $invoice->currency_name)); ?></td>
                            </tr>
                            <?php } ?>
                            <?php if (get_option('show_amount_due_on_invoice') == 1 && $invoice->status != Invoices_model::STATUS_CANCELLED) { ?>
                            <tr style="background: <?= $invoice->total_left_to_pay > 0 ? '#f8d7da' : '#d4edda'; ?>;">
                                <td style="font-weight: bold; color: <?= $invoice->total_left_to_pay > 0 ? '#721c24' : '#155724'; ?>;">المبلغ المتبقي</td>
                                <td style="font-weight: bold; color: <?= $invoice->total_left_to_pay > 0 ? '#721c24' : '#155724'; ?>;"><?= e(app_format_money($invoice->total_left_to_pay, $invoice->currency_name)); ?></td>
                            </tr>
                            <?php } ?>
                        </table>
                    </div>
                </div>

                <?php if (count($invoice->attachments) > 0 && $invoice->visible_attachments_to_customer_found == true) { ?>
                <div class="clearfix"></div>
                <hr />
                <p style="font-weight: bold;"><?= _l('invoice_files'); ?></p>
                <?php foreach ($invoice->attachments as $attachment) {
                    if ($attachment['visible_to_customer'] == 0) {
                        continue;
                    }
                    $attachment_url = site_url('download/file/sales_attachment/' . $attachment['attachment_key']);
                    if (!empty($attachment['external'])) {
                        $attachment_url = $attachment['external_link'];
                    } ?>
                <div class="row" style="margin-bottom: 10px;">
                    <div class="col-md-12">
                        <i class="<?= get_mime_class($attachment['filetype']); ?>"></i>
                        <a href="<?= e($attachment_url); ?>"><?= e($attachment['file_name']); ?></a>
                    </div>
                </div>
                <?php } ?>
                <?php } ?>

                <?php if (!empty($invoice->clientnote)) { ?>
                <div class="col-md-12 mtop15 text-right">
                    <p style="font-weight: bold;"><?= _l('invoice_note'); ?></p>
                    <div style="color: #666;">
                        <?= process_text_content_for_display($invoice->clientnote); ?>
                    </div>
                </div>
                <?php } ?>
                
                <?php if (!empty($invoice->terms)) { ?>
                <div class="col-md-12 mtop15 text-right">
                    <hr />
                    <p style="font-weight: bold;"><?= _l('terms_and_conditions'); ?></p>
                    <div style="color: #666;">
                        <?= process_text_content_for_display($invoice->terms); ?>
                    </div>
                </div>
                <?php } ?>
            </div>

            <!-- جدول المدفوعات -->
            <div class="col-md-12" style="margin-top: 30px;">
                <hr />
                <p><b><?= _l('invoice_received_payments'); ?></b></p>
                <?php $total_payments = count($invoice->payments);
                if ($total_payments > 0) { ?>
                <table class="table table-hover invoice-payments-table tw-mt-2.5">
                    <thead>
                        <tr>
                            <th><?= _l('invoice_payments_table_number_heading'); ?></th>
                            <th><?= _l('invoice_payments_table_mode_heading'); ?></th>
                            <th><?= _l('invoice_payments_table_date_heading'); ?></th>
                            <th><?= _l('invoice_payments_table_amount_heading'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($invoice->payments as $payment) { ?>
                        <tr>
                            <td>
                                <span class="pull-left"><?= e($payment['paymentid']); ?></span>
                                <?= form_open($this->uri->uri_string()); ?>
                                <button type="submit" value="<?= e($payment['paymentid']); ?>"
                                    class="btn btn-icon btn-default pull-right" name="paymentpdf">
                                    <i class="fa-regular fa-file-pdf"></i>
                                </button>
                                <?= form_close(); ?>
                            </td>
                            <td><?= e($payment['name']); ?>
                                <?php if (!empty($payment['paymentmethod'])) {
                                    echo ' - ' . $payment['paymentmethod'];
                                } ?>
                            </td>
                            <td><?= e(_d($payment['date'])); ?></td>
                            <td><?= e(app_format_money($payment['amount'], $invoice->currency_name)); ?></td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
                <hr />
                <?php } else { ?>
                <h5 class="tw-font-medium tw-mt-0 tw-text-neutral-500">
                    <?= _l('invoice_no_payments_found'); ?>
                </h5>
                <hr />
                <?php } ?>
            </div>

            <!-- طرق الدفع -->
            <?php if (($invoice->status != Invoices_model::STATUS_PAID
                && $invoice->status != Invoices_model::STATUS_CANCELLED
                && $invoice->total > 0)) { ?>
            <div class="col-md-12">
                <div class="row">
                    <?php $found_online_mode = false;
                    if (found_invoice_mode($payment_modes, $invoice->id, false)) {
                        $found_online_mode = true; ?>
                    <div class="col-md-6 text-left">
                        <p class="tw-mb-2.5 tw-font-medium">
                            <?= _l('invoice_html_online_payment'); ?>
                        </p>
                        <?= form_open($this->uri->uri_string(), ['id' => 'online_payment_form', 'novalidate' => true]); ?>
                        <?php foreach ($payment_modes as $mode) {
                            if (!is_numeric($mode['id']) && !empty($mode['id'])) {
                                if (!is_payment_mode_allowed_for_invoice($mode['id'], $invoice->id)) {
                                    continue;
                                } ?>
                        <div class="radio radio-success online-payment-radio">
                            <input type="radio" value="<?= e($mode['id']); ?>"
                                id="pm_<?= e($mode['id']); ?>" name="paymentmode">
                            <label for="pm_<?= e($mode['id']); ?>"><?= e($mode['name']); ?></label>
                        </div>
                        <?php if (!empty($mode['description'])) { ?>
                        <div class="mbot15">
                            <?= process_text_content_for_display($mode['description']); ?>
                        </div>
                        <?php }
                            }
                        } ?>
                        <div class="form-group mtop25">
                            <?php if (get_option('allow_payment_amount_to_be_modified') == 1) { ?>
                            <label for="amount" class="control-label"><?= _l('invoice_html_amount'); ?></label>
                            <div class="input-group">
                                <input type="number" required max="<?= e($invoice->total_left_to_pay); ?>"
                                    data-total="<?= e($invoice->total_left_to_pay); ?>"
                                    name="amount" class="form-control"
                                    value="<?= e($invoice->total_left_to_pay); ?>">
                                <span class="input-group-addon"><?= e($invoice->symbol); ?></span>
                            </div>
                            <?php } else {
                                echo '<h4 class="bold mbot25">' . e(_l('invoice_html_total_pay', app_format_money($invoice->total_left_to_pay, $invoice->currency_name))) . '</h4>';
                            } ?>
                        </div>
                        <div id="pay_button">
                            <input id="pay_now" type="submit" name="make_payment" class="btn btn-success"
                                value="<?= _l('invoice_html_online_payment_button_text'); ?>">
                        </div>
                        <input type="hidden" name="hash" value="<?= e($hash); ?>">
                        <?= form_close(); ?>
                    </div>
                    <?php } ?>
                    <?php if (found_invoice_mode($payment_modes, $invoice->id)) { ?>
                    <div class="invoice-html-offline-payments <?php if ($found_online_mode == true) {
                        echo 'col-md-6 text-right';
                    } else {
                        echo 'col-md-12';
                    } ?>">
                        <p class="tw-mb-2.5 tw-font-medium">
                            <?= _l('invoice_html_offline_payment'); ?>
                        </p>
                        <?php foreach ($payment_modes as $mode) {
                            if (is_numeric($mode['id'])) {
                                if (!is_payment_mode_allowed_for_invoice($mode['id'], $invoice->id)) {
                                    continue;
                                } ?>
                        <p class="bold"><?= e($mode['name']); ?></p>
                        <?php if (!empty($mode['description'])) { ?>
                        <div class="mbot15">
                            <?= process_text_content_for_display($mode['description']); ?>
                        </div>
                        <?php }
                            }
                        } ?>
                    </div>
                    <?php } ?>
                </div>
            </div>
            <?php } ?>
        </div>
    </div>
</div>

<script>
    $(function() {
        new Sticky('[data-sticky]');
        var $payNowTop = $('.pay-now-top');
        if ($payNowTop.length && !$('#pay_now').isInViewport()) {
            $payNowTop.removeClass('hide');
            $('.pay-now-top').on('click', function(e) {
                e.preventDefault();
                $('html,body').animate({
                        scrollTop: $("#online_payment_form").offset().top
                    },
                    'slow');
            });
        }

        $('#online_payment_form').appFormValidator();

        var online_payments = $('.online-payment-radio');
        if (online_payments.length == 1) {
            online_payments.find('input').prop('checked', true);
        }
    });
</script>