USE [Faainex.Erp.Main.Test]
GO

/****** Object:  StoredProcedure [dbo].[AccTradingLossAndProfit]    Script Date: 11/5/2025 10:20:24 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


ALTER PROCEDURE [dbo].[AccTradingLossAndProfit] 
    @FromDate NVARCHAR(50),
    @ToDate NVARCHAR(50),
    @AccLevel INT,
    @BranchID INT,
    @FileYearID INT,
    @Ln INT,
    @Stock INT,
    @StockOpen INT,
    @CostCenterR NVARCHAR(MAX),
    @ZeroBalance INT,
    @CompanyID INT   -- ✅ إضافة فلتر الشركة
AS
BEGIN
    SET NOCOUNT ON;

    -----------------------------------------------------------------------
    -- 🔹 تعريف المتغيرات
    -----------------------------------------------------------------------
    DECLARE 
        @debitL FLOAT, @CreditL FLOAT,
        @Profit FLOAT, @Loss FLOAT,
        @debitLP FLOAT, @CreditLP FLOAT,
        @Profit1 FLOAT, @Loss1 FLOAT,
        @StockCost FLOAT,
        @AccName1 NVARCHAR(150),
        @BID INT;

    CREATE TABLE #Temp (
        AccID NVARCHAR(50),
        AccName NVARCHAR(150),
        Debit1 FLOAT,
        Credit1 FLOAT,
        MainFinalAccount INT,
        LevelAccount INT,
        BranchId INT,
        [Status] BIT
    );

    CREATE TABLE #Totals (
        AccName NVARCHAR(150),
        Debit1 FLOAT,
        Credit1 FLOAT
    );

    -----------------------------------------------------------------------
    -- 🔹 تحديد الفروع حسب الشركة
    -----------------------------------------------------------------------
    DECLARE @BranchTable TABLE (BranchID INT);

    IF @CompanyID = 0 AND @BranchID = 0
        INSERT INTO @BranchTable SELECT BWCode FROM BranchsAndWarehouse;
    ELSE IF @CompanyID = 0 AND @BranchID <> 0
        INSERT INTO @BranchTable SELECT @BranchID;
    ELSE IF @CompanyID <> 0 AND @BranchID = 0
        INSERT INTO @BranchTable SELECT BWCode FROM BranchsAndWarehouse WHERE CompanyId = @CompanyID;
    ELSE
        INSERT INTO @BranchTable SELECT @BranchID;

    -----------------------------------------------------------------------
    -- 🔹 التكرار عبر الفروع
    -----------------------------------------------------------------------
    DECLARE BranchCursor CURSOR FOR SELECT BranchID FROM @BranchTable;
    OPEN BranchCursor;
    FETCH NEXT FROM BranchCursor INTO @BID;

    WHILE @@FETCH_STATUS = 0
    BEGIN
        SET @StockCost=0;
        SET @debitL=0; SET @CreditL=0;
        SET @debitLP=0; SET @CreditLP=0;

        -----------------------------------------------------------------------
        -- حساب المخزون آخر المدة
        -----------------------------------------------------------------------
        IF @Stock = 0
            SELECT @StockCost = ISNULL(SUM(ISNULL(PriceAverage,0) * ISNULL(QuantityAv,0)),0)
            FROM ViewItems WHERE BranchID=@BID;

        -----------------------------------------------------------------------
        -- حسابات الأرباح والخسائر من الميزان
        -----------------------------------------------------------------------
        IF @CostCenterR='0'
        BEGIN
            SELECT @debitL = ISNULL(SUM(Debit - Credit),0)
            FROM ViewTrialBalance
            WHERE MainFinalAccount=0 AND LevelAccount=1 AND FinancialID=@FileYearID 
                  AND BranchID=@BID AND (Debit-Credit)>0 AND DateGr BETWEEN @FromDate AND @ToDate;

            SELECT @CreditL = ISNULL(SUM(ABS(Debit - Credit)),0)
            FROM ViewTrialBalance
            WHERE MainFinalAccount=0 AND LevelAccount=1 AND FinancialID=@FileYearID 
                  AND BranchID=@BID AND (Debit-Credit)<0 AND DateGr BETWEEN @FromDate AND @ToDate;

            SELECT @debitLP = ISNULL(SUM(Debit - Credit),0)
            FROM ViewTrialBalance
            WHERE MainFinalAccount=1 AND LevelAccount=1 AND FinancialID=@FileYearID 
                  AND BranchID=@BID AND (Debit-Credit)>0 AND DateGr BETWEEN @FromDate AND @ToDate;

            SELECT @CreditLP = ISNULL(SUM(ABS(Debit - Credit)),0)
            FROM ViewTrialBalance
            WHERE MainFinalAccount=1 AND LevelAccount=1 AND FinancialID=@FileYearID 
                  AND BranchID=@BID AND (Debit-Credit)<0 AND DateGr BETWEEN @FromDate AND @ToDate;
        END
        ELSE
        BEGIN
            SELECT @debitL = ISNULL(SUM(Debit - Credit),0)
            FROM ViewTrialBalance
            WHERE MainFinalAccount=0 AND LevelAccount=1 AND FinancialID=@FileYearID 
                  AND BranchID=@BID AND (Debit-Credit)>0 
                  AND DateGr BETWEEN @FromDate AND @ToDate
                  AND CostCenterID IN (SELECT * FROM dbo.CostCenterData(@CostCenterR));

            SELECT @CreditL = ISNULL(SUM(ABS(Debit - Credit)),0)
            FROM ViewTrialBalance
            WHERE MainFinalAccount=0 AND LevelAccount=1 AND FinancialID=@FileYearID 
                  AND BranchID=@BID AND (Debit-Credit)<0 
                  AND DateGr BETWEEN @FromDate AND @ToDate
                  AND CostCenterID IN (SELECT * FROM dbo.CostCenterData(@CostCenterR));

            SELECT @debitLP = ISNULL(SUM(Debit - Credit),0)
            FROM ViewTrialBalance
            WHERE MainFinalAccount=1 AND LevelAccount=1 AND FinancialID=@FileYearID 
                  AND BranchID=@BID AND (Debit-Credit)>0 
                  AND DateGr BETWEEN @FromDate AND @ToDate
                  AND CostCenterID IN (SELECT * FROM dbo.CostCenterData(@CostCenterR));

            SELECT @CreditLP = ISNULL(SUM(ABS(Debit - Credit)),0)
            FROM ViewTrialBalance
            WHERE MainFinalAccount=1 AND LevelAccount=1 AND FinancialID=@FileYearID 
                  AND BranchID=@BID AND (Debit-Credit)<0 
                  AND DateGr BETWEEN @FromDate AND @ToDate
                  AND CostCenterID IN (SELECT * FROM dbo.CostCenterData(@CostCenterR));
        END

        -----------------------------------------------------------------------
        -- حساب الربح والخسارة
        -----------------------------------------------------------------------
        SET @Profit  = CASE WHEN @CreditL + @StockCost >= @debitL THEN (@CreditL + @StockCost) - @debitL ELSE 0 END;
        SET @Loss    = CASE WHEN @CreditL + @StockCost >= @debitL THEN 0 ELSE @debitL - (@CreditL + @StockCost) END;

        SET @AccName1 = CASE 
            WHEN @Creditlp + @Profit >= @debitlp + @Loss 
                THEN CASE WHEN @Ln=0 THEN N'## إجمــالي صــــافــي الــربـــح ##' ELSE N'## Total Net Profit ##' END
            ELSE CASE WHEN @Ln=0 THEN N'## إجمــالي صــــافــي الـخـسـارة ##' ELSE N'## Total Net Loss ##' END END;

        SET @Profit1 = CASE WHEN @Creditlp + @Profit >= @debitlp + @Loss 
                            THEN @Creditlp + @Profit - (@debitlp + @Loss) ELSE 0 END;
        SET @Loss1   = CASE WHEN @Creditlp + @Profit >= @debitlp + @Loss 
                            THEN 0 ELSE (@debitlp + @Loss) - (@Creditlp + @Profit) END;

        -----------------------------------------------------------------------
        -- ✅ تخزين القيم في الجدول العام
        -----------------------------------------------------------------------
        INSERT INTO #Totals(AccName, Debit1, Credit1)
        VALUES (@AccName1, @Profit1, @Loss1);

        INSERT INTO #Totals(AccName, Debit1, Credit1)
        VALUES (N'## الاجمــــالي ##', @Profit1 + @Loss1, @Profit1 + @Loss1);

        -----------------------------------------------------------------------
        -- الحسابات العادية للفروع (تظل كما هي)
        -----------------------------------------------------------------------
        INSERT INTO #Temp
        SELECT 
            AccID, AccName,
            CASE WHEN dbo.GetPreBalDebitT(AccID,@FromDate,@ToDate,@BID,@FileYearID,1,@CostCenterR)
                    - dbo.GetPreBalCreditT(AccID,@FromDate,@ToDate,@BID,@FileYearID,1,@CostCenterR) >= 0
                THEN dbo.GetPreBalDebitT(AccID,@FromDate,@ToDate,@BID,@FileYearID,1,@CostCenterR)
                     - dbo.GetPreBalCreditT(AccID,@FromDate,@ToDate,@BID,@FileYearID,1,@CostCenterR)
                ELSE 0 END,
            CASE WHEN dbo.GetPreBalDebitT(AccID,@FromDate,@ToDate,@BID,@FileYearID,1,@CostCenterR)
                    - dbo.GetPreBalCreditT(AccID,@FromDate,@ToDate,@BID,@FileYearID,1,@CostCenterR) >= 0
                THEN 0 ELSE ABS(dbo.GetPreBalDebitT(AccID,@FromDate,@ToDate,@BID,@FileYearID,1,@CostCenterR)
                     - dbo.GetPreBalCreditT(AccID,@FromDate,@ToDate,@BID,@FileYearID,1,@CostCenterR)) END,
            MainFinalAccount, LevelAccount, @BID, [Status]
        FROM ViewChartOfAccount
        WHERE MainFinalAccount IN (0,1)
          AND LevelAccount <= @AccLevel
          AND BranchID=@BID
          AND FinancialID=@FileYearID
          AND AccID <> '0';

        FETCH NEXT FROM BranchCursor INTO @BID;
    END

    CLOSE BranchCursor;
    DEALLOCATE BranchCursor;

    -----------------------------------------------------------------------
    -- 🔹 تجميع الثلاثة الثابتين في النهاية مرة واحدة
    -----------------------------------------------------------------------
    DELETE FROM #Temp WHERE AccName LIKE '##%##';  -- نحذف التكرارات

    INSERT INTO #Temp
    SELECT NULL, AccName, SUM(Debit1), SUM(Credit1), 0, 1, 0, 1
    FROM #Totals
    GROUP BY AccName;

    -----------------------------------------------------------------------
    -- 🔹 إخراج النتائج
    -----------------------------------------------------------------------
    IF @ZeroBalance=0
        SELECT * FROM #Temp ORDER BY CASE WHEN AccName LIKE '##%' THEN 1 ELSE 0 END, AccName;
    ELSE
        SELECT * FROM #Temp WHERE Debit1 <> 0 OR Credit1 <> 0
        ORDER BY CASE WHEN AccName LIKE '##%' THEN 1 ELSE 0 END, AccName;
END
GO

