USE [Faainex.Erp.Main.Test]
GO

/****** Object:  StoredProcedure [dbo].[AccTradingLossAndProfit1]    Script Date: 11/5/2025 10:20:45 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


ALTER PROCEDURE [dbo].[AccTradingLossAndProfit1]        
    @FromDate NVARCHAR(50),
    @ToDate NVARCHAR(50),
    @AccLevel INT,
    @BranchID INT,
    @FileYearID INT,
    @Ln INT,
    @Stock INT,
    @StockOpen INT,
    @CostCenterR NVARCHAR(MAX),
    @ZeroBalance INT,
    @CompanyID INT = 0  -- ✅ تمت الإضافة لدعم اختيار الشركة
AS
BEGIN
    SET NOCOUNT ON;

    -----------------------------------------------------------------------
    -- 🔹 تعريف الجداول المؤقتة
    -----------------------------------------------------------------------
    CREATE TABLE #Temp (
        AccID NVARCHAR(50),
        AccName NVARCHAR(150),
        Debit1 FLOAT,
        Credit1 FLOAT,
        MainFinalAccount INT,
        LevelAccount INT,
        BranchId INT,
        [Status] BIT
    );

    CREATE TABLE #Totals (
        AccName NVARCHAR(150),
        Debit1 FLOAT,
        Credit1 FLOAT
    );

    -----------------------------------------------------------------------
    -- 🔹 تحديد الفروع بناءً على الشركة
    -----------------------------------------------------------------------
    DECLARE @BranchTable TABLE (BranchID INT);

    IF @CompanyID = 0 AND @BranchID = 0
        INSERT INTO @BranchTable SELECT BWCode FROM BranchsAndWarehouse;
    ELSE IF @CompanyID <> 0 AND @BranchID = 0
        INSERT INTO @BranchTable SELECT BWCode FROM BranchsAndWarehouse WHERE CompanyId=@CompanyID;
    ELSE
        INSERT INTO @BranchTable SELECT @BranchID;

    -----------------------------------------------------------------------
    -- 🔹 تعريف المتغيرات الحسابية
    -----------------------------------------------------------------------
    DECLARE 
        @BID INT,
        @debitL FLOAT, @CreditL FLOAT,
        @Profit FLOAT, @Loss FLOAT,
        @debitLP FLOAT, @CreditLP FLOAT,
        @Profit1 FLOAT, @Loss1 FLOAT,
        @StockCost FLOAT,
        @AccName1 NVARCHAR(150);

    -----------------------------------------------------------------------
    -- 🔹 تكرار على الفروع لحساب المجاميع
    -----------------------------------------------------------------------
    DECLARE branchCursor CURSOR FOR SELECT BranchID FROM @BranchTable;
    OPEN branchCursor;
    FETCH NEXT FROM branchCursor INTO @BID;

    WHILE @@FETCH_STATUS = 0
    BEGIN
        SET @StockCost = 0;
        SET @debitL=0; SET @CreditL=0; SET @debitLP=0; SET @CreditLP=0;

        -----------------------------------------------------------------------
        -- حساب المخزون
        -----------------------------------------------------------------------
        IF @Stock=0
            SELECT @StockCost = ISNULL(SUM(ISNULL(PriceAverage,0) * ISNULL(QuantityAv,0)),0)
            FROM ViewItems WHERE BranchID=@BID;

        -----------------------------------------------------------------------
        -- حساب الأرباح والخسائر
        -----------------------------------------------------------------------
        IF @CostCenterR='0'
        BEGIN
            SELECT @debitL = ISNULL(SUM(Debit-Credit),0)
            FROM ViewTrialBalance WHERE MainFinalAccount=0 AND LevelAccount=1 AND FinancialID=@FileYearID
            AND BranchID=@BID AND (Debit-Credit)>0 AND DateGr BETWEEN @FromDate AND @ToDate;

            SELECT @CreditL = ISNULL(SUM(ABS(Debit-Credit)),0)
            FROM ViewTrialBalance WHERE MainFinalAccount=0 AND LevelAccount=1 AND FinancialID=@FileYearID
            AND BranchID=@BID AND (Debit-Credit)<0 AND DateGr BETWEEN @FromDate AND @ToDate;

            SELECT @debitLP = ISNULL(SUM(Debit-Credit),0)
            FROM ViewTrialBalance WHERE MainFinalAccount=1 AND LevelAccount=1 AND FinancialID=@FileYearID
            AND BranchID=@BID AND (Debit-Credit)>0 AND DateGr BETWEEN @FromDate AND @ToDate;

            SELECT @CreditLP = ISNULL(SUM(ABS(Debit-Credit)),0)
            FROM ViewTrialBalance WHERE MainFinalAccount=1 AND LevelAccount=1 AND FinancialID=@FileYearID
            AND BranchID=@BID AND (Debit-Credit)<0 AND DateGr BETWEEN @FromDate AND @ToDate;
        END
        ELSE
        BEGIN
            SELECT @debitL = ISNULL(SUM(Debit-Credit),0)
            FROM ViewTrialBalance WHERE MainFinalAccount=0 AND LevelAccount=1 AND FinancialID=@FileYearID
            AND BranchID=@BID AND (Debit-Credit)>0 AND DateGr BETWEEN @FromDate AND @ToDate
            AND CostCenterID IN (SELECT * FROM dbo.CostCenterData(@CostCenterR));

            SELECT @CreditL = ISNULL(SUM(ABS(Debit-Credit)),0)
            FROM ViewTrialBalance WHERE MainFinalAccount=0 AND LevelAccount=1 AND FinancialID=@FileYearID
            AND BranchID=@BID AND (Debit-Credit)<0 AND DateGr BETWEEN @FromDate AND @ToDate
            AND CostCenterID IN (SELECT * FROM dbo.CostCenterData(@CostCenterR));

            SELECT @debitLP = ISNULL(SUM(Debit-Credit),0)
            FROM ViewTrialBalance WHERE MainFinalAccount=1 AND LevelAccount=1 AND FinancialID=@FileYearID
            AND BranchID=@BID AND (Debit-Credit)>0 AND DateGr BETWEEN @FromDate AND @ToDate
            AND CostCenterID IN (SELECT * FROM dbo.CostCenterData(@CostCenterR));

            SELECT @CreditLP = ISNULL(SUM(ABS(Debit-Credit)),0)
            FROM ViewTrialBalance WHERE MainFinalAccount=1 AND LevelAccount=1 AND FinancialID=@FileYearID
            AND BranchID=@BID AND (Debit-Credit)<0 AND DateGr BETWEEN @FromDate AND @ToDate
            AND CostCenterID IN (SELECT * FROM dbo.CostCenterData(@CostCenterR));
        END

        -----------------------------------------------------------------------
        -- تحديد نوع الحساب النهائي
        -----------------------------------------------------------------------
        SET @Profit  = CASE WHEN @CreditL + @StockCost >= @debitL THEN (@CreditL + @StockCost) - @debitL ELSE 0 END;
        SET @Loss    = CASE WHEN @CreditL + @StockCost >= @debitL THEN 0 ELSE @debitL - (@CreditL + @StockCost) END;

        SET @AccName1 = CASE 
            WHEN @CreditLP + @Profit >= @debitLP + @Loss 
                THEN CASE WHEN @Ln=0 THEN N'## إجمــالي صــــافــي الــربـــح ##' ELSE N'## Total Net Profit ##' END
            ELSE CASE WHEN @Ln=0 THEN N'## إجمــالي صــــافــي الـخـسـارة ##' ELSE N'## Total Net Loss ##' END
        END;

        SET @Profit1 = CASE WHEN @CreditLP + @Profit >= @debitLP + @Loss 
                            THEN @CreditLP + @Profit - (@debitLP + @Loss) ELSE 0 END;
        SET @Loss1   = CASE WHEN @CreditLP + @Profit >= @debitLP + @Loss 
                            THEN 0 ELSE (@debitLP + @Loss) - (@CreditLP + @Profit) END;

        -----------------------------------------------------------------------
        -- تخزين القيم في جدول التجميع
        -----------------------------------------------------------------------
        INSERT INTO #Totals(AccName, Debit1, Credit1)
        VALUES (N'## إجـمـالـي ربــح الـمـتـاجرة##', @Profit, @Loss);

        INSERT INTO #Totals(AccName, Debit1, Credit1)
        VALUES (@AccName1, @Profit1, @Loss1);

        INSERT INTO #Totals(AccName, Debit1, Credit1)
        VALUES (N'## الاجمــــالي ##', @Profit1 + @Loss1, @Profit1 + @Loss1);

        -----------------------------------------------------------------------
        -- باقي الحسابات من شجرة الحسابات
        -----------------------------------------------------------------------
        INSERT INTO #Temp
        SELECT AccID, AccName,
               CASE WHEN dbo.GetPreBalDebitT(AccID,@FromDate,@ToDate,@BID,@FileYearID,2,@CostCenterR)
                        - dbo.GetPreBalCreditT(AccID,@FromDate,@ToDate,@BID,@FileYearID,2,@CostCenterR) >= 0
                    THEN dbo.GetPreBalDebitT(AccID,@FromDate,@ToDate,@BID,@FileYearID,2,@CostCenterR)
                         - dbo.GetPreBalCreditT(AccID,@FromDate,@ToDate,@BID,@FileYearID,2,@CostCenterR)
                    ELSE 0 END,
               CASE WHEN dbo.GetPreBalDebitT(AccID,@FromDate,@ToDate,@BID,@FileYearID,2,@CostCenterR)
                        - dbo.GetPreBalCreditT(AccID,@FromDate,@ToDate,@BID,@FileYearID,2,@CostCenterR) < 0
                    THEN ABS(dbo.GetPreBalDebitT(AccID,@FromDate,@ToDate,@BID,@FileYearID,2,@CostCenterR)
                         - dbo.GetPreBalCreditT(AccID,@FromDate,@ToDate,@BID,@FileYearID,2,@CostCenterR))
                    ELSE 0 END,
               MainFinalAccount, LevelAccount, @BID, [Status]
        FROM ViewChartOfAccount
        WHERE MainFinalAccount IN (0,1) AND LevelAccount <= @AccLevel
              AND BranchID=@BID AND FinancialID=@FileYearID;

        FETCH NEXT FROM branchCursor INTO @BID;
    END

    CLOSE branchCursor;
    DEALLOCATE branchCursor;

    -----------------------------------------------------------------------
    -- 🔹 إزالة التكرارات وتجميع الثلاثة الثابتين مرة واحدة
    -----------------------------------------------------------------------
    DELETE FROM #Temp WHERE AccName LIKE '##%##';

    INSERT INTO #Temp
    SELECT NULL, AccName, SUM(Debit1), SUM(Credit1), 0, 1, 0, 1
    FROM #Totals
    GROUP BY AccName;

    -----------------------------------------------------------------------
    -- 🔹 إخراج النتائج مرتبة بحيث تكون الثلاثة الثابتين في النهاية
    -----------------------------------------------------------------------
    IF @ZeroBalance=0
        SELECT * FROM #Temp
        ORDER BY CASE 
                    WHEN AccName LIKE N'## إجـمـالـي ربــح الـمـتـاجرة##' THEN 1
                    WHEN AccName LIKE N'## إجمــالي صــــافــي%' THEN 2
                    WHEN AccName LIKE N'## الاجمــــالي ##' THEN 3
                    ELSE 0 END,
                 AccName;
    ELSE
        SELECT * FROM #Temp
        WHERE Debit1 <> 0 OR Credit1 <> 0
        ORDER BY CASE 
                    WHEN AccName LIKE N'## إجـمـالـي ربــح الـمـتـاجرة##' THEN 1
                    WHEN AccName LIKE N'## إجمــالي صــــافــي%' THEN 2
                    WHEN AccName LIKE N'## الاجمــــالي ##' THEN 3
                    ELSE 0 END,
                 AccName;
END
GO

